"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createManagementPowerExecutors = void 0;
const OfflineActionsUploader_1 = require("../../../Offline/OfflineActionsUploader");
const PowerKernel_1 = require("./PowerKernel");
const powerFacade_1 = require("./powerFacade");
const powerActionTimers_1 = require("./powerActionTimers");
/**
 * Creates management power kernel, facade and action timer, which can be used in management saga and front saga,
 * to handle scheduling reboot power actions via JS API.
 * @param managementDriver {@link IManagementDriver}
 * @param cacheDriver {@link ICacheDriver}
 */
function createManagementPowerExecutors(managementDriver, cacheDriver) {
    const offlineActionHandler = new OfflineActionsUploader_1.OfflineActionsUploader('management.', managementDriver.fileSystem);
    const powerKernel = new PowerKernel_1.PowerKernel(managementDriver);
    const powerExecutorFacade = new powerFacade_1.PowerFacade({ managementDriver, cacheDriver }, offlineActionHandler, powerKernel);
    const powerActionTimer = (0, powerActionTimers_1.createManagementPowerActionTimer)(() => cacheDriver, powerExecutorFacade);
    return { powerExecutorFacade, powerActionTimer, powerKernel };
}
exports.createManagementPowerExecutors = createManagementPowerExecutors;
//# sourceMappingURL=powerExecutors.js.map