import { PowerKernel } from './PowerKernel';
import { PowerFacade } from './powerFacade';
import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import ICacheDriver from '../../../NativeDevice/ICacheDriver';
import IPowerActionTimer from '../../../NativeDevice/Power/IPowerActionTimer';
export interface PowerExecutors {
    powerExecutorFacade: PowerFacade;
    powerActionTimer: IPowerActionTimer;
    powerKernel: PowerKernel;
}
/**
 * Creates management power kernel, facade and action timer, which can be used in management saga and front saga,
 * to handle scheduling reboot power actions via JS API.
 * @param managementDriver {@link IManagementDriver}
 * @param cacheDriver {@link ICacheDriver}
 */
export declare function createManagementPowerExecutors(managementDriver: IManagementDriver, cacheDriver: ICacheDriver): PowerExecutors;
