"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceSchedulePowerAction = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const devicePowerActions_1 = require("@signageos/actions/dist/Device/Power/devicePowerActions");
const PowerActionType_1 = __importDefault(require("@signageos/actions/dist/Device/Power/PowerActionType"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const deviceSchedulePowerActionSagas_1 = require("../../../Device/Power/deviceSchedulePowerActionSagas");
function* deviceSchedulePowerAction(getNativeDriver, responsibilities, powerActionTimer) {
    if (!responsibilities.has(Responsibility_1.default.SCHEDULED_POWER)) {
        return;
    }
    yield (0, socketActionCreator_1.bindWhenPlatform)([devicePowerActions_1.SchedulePowerAction, devicePowerActions_1.CancelScheduledPowerAction]);
    const supportsSchedulePowerAction = yield getNativeDriver().managementSupports(ManagementCapability_1.default.SCHEDULE_POWER_ACTION);
    if (!supportsSchedulePowerAction) {
        return;
    }
    yield (0, deviceSchedulePowerActionSagas_1.deviceSchedulePowerActionCommon)(powerActionTimer, (powerType) => {
        return (powerType === PowerActionType_1.default.SYSTEM_REBOOT ||
            powerType === PowerActionType_1.default.APP_RESTART ||
            powerType === PowerActionType_1.default.DISPLAY_POWER_ON ||
            powerType === PowerActionType_1.default.DISPLAY_POWER_OFF);
    });
}
exports.deviceSchedulePowerAction = deviceSchedulePowerAction;
//# sourceMappingURL=deviceSchedulePowerActionSagas.js.map