"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPowerActionsScheduleSettings = exports.telemetryDevicePowerActionsSaga = void 0;
const DeviceTelemetryType_1 = require("@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType");
const PowerActionType_1 = __importDefault(require("@signageos/common-types/dist/Device/Power/PowerActionType"));
const deviceTelemetrySagas_1 = require("../Telemetry/deviceTelemetrySagas");
const Weekday_1 = __importDefault(require("@signageos/common-types/dist/Device/Time/Weekday"));
const PowerActionType_2 = __importDefault(require("@signageos/actions/dist/Device/Power/PowerActionType"));
const Weekday_2 = __importDefault(require("@signageos/actions/dist/Misc/Weekday"));
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
exports.telemetryDevicePowerActionsSaga = (0, deviceTelemetrySagas_1.createDeviceTelemetrySaga)(DeviceTelemetryType_1.DeviceTelemetryType.POWER_ACTIONS_SCHEDULE, Responsibility_1.default.SCHEDULED_POWER, [ManagementCapability_1.default.SCHEDULE_POWER_ACTION], getPowerActionsScheduleSettings);
function getPowerActionsScheduleSettings({ powerActionRules, }) {
    return __awaiter(this, void 0, void 0, function* () {
        const scheduledActions = yield powerActionRules();
        return Object.keys(scheduledActions).map((uid) => {
            const powerAction = scheduledActions[uid];
            return {
                uid,
                powerType: PowerActionType_1.default[PowerActionType_2.default[powerAction.powerType]],
                weekdays: powerAction.weekdays.map((weekday) => Weekday_1.default[Weekday_2.default[weekday]]),
                time: powerAction.time,
            };
        });
    });
}
exports.getPowerActionsScheduleSettings = getPowerActionsScheduleSettings;
//# sourceMappingURL=devicePowerActionTelemetrySagas.js.map