"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PowerKernel = void 0;
class PowerKernel {
    constructor(managementDriver) {
        this.managementDriver = managementDriver;
        this._callbacks = [];
    }
    doBeforeShutDown(callback) {
        var _a;
        (_a = this._callbacks) === null || _a === void 0 ? void 0 : _a.push(callback);
    }
    appRestart() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.runCallbacks();
            return yield this.managementDriver.appRestart();
        });
    }
    systemReboot() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.runCallbacks();
            return yield this.managementDriver.systemReboot();
        });
    }
    runCallbacks() {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            try {
                return yield Promise.all((_a = this._callbacks) === null || _a === void 0 ? void 0 : _a.map((callback) => __awaiter(this, void 0, void 0, function* () {
                    return yield callback();
                })));
            }
            catch (error) {
                console.error('Error when calling callback before shutDown', error);
            }
        });
    }
}
exports.PowerKernel = PowerKernel;
//# sourceMappingURL=PowerKernel.js.map