"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/front-display:NativeDevice:Power:ManagementPowerActionExecutor');
class ManagementPowerActionExecutor {
    constructor(powerActions) {
        this.powerActions = powerActions;
    }
    execute(powerAction) {
        new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
            const success = yield this.powerActions.performPowerAction(powerAction);
            if (success) {
                resolve();
            }
            else {
                reject(new Error(`Unsupported power action: ${powerAction}`));
            }
        })).catch((reason) => {
            debug(`Failed to perform scheduled power action: ${reason}`);
        });
    }
}
exports.default = ManagementPowerActionExecutor;
//# sourceMappingURL=ManagementPowerActionExecutor.js.map