"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.devicePolicySaga = void 0;
const effects_1 = require("redux-saga/effects");
const brightnessPolicySagas_1 = require("../../Device/Brightness/brightnessPolicySagas");
const deviceVolumePolicySagas_1 = require("../../Device/Audio/deviceVolumePolicySagas");
const deviceResolutionPolicySagas_1 = require("../../Device/Screen/deviceResolutionPolicySagas");
const deviceOrientationPolicySagas_1 = require("../../Device/Screen/deviceOrientationPolicySagas");
const deviceRemoteControlPolicySagas_1 = require("../../Device/RemoteControl/deviceRemoteControlPolicySagas");
const deviceApplicationPolicySagas_1 = require("../../Device/Application/deviceApplicationPolicySagas");
const deviceFirmwarePolicySagas_1 = require("../../Device/Firmware/deviceFirmwarePolicySagas");
const deviceDebugPolicySagas_1 = require("../../Device/Debug/deviceDebugPolicySagas");
const deviceDateTimePolicySagas_1 = require("../../Device/DateTime/deviceDateTimePolicySagas");
const devicePowerActionPolicySagas_1 = require("../../Device/Power/devicePowerActionPolicySagas");
const deviceTimerPolicySagas_1 = require("../../Device/Timer/deviceTimerPolicySagas");
const extendedManagementPolicySagas_1 = require("../../Extended/extendedManagementPolicySagas");
const peerRecoveryPolicySaga_1 = require("../PeerRecovery/peerRecoveryPolicySaga");
const autoRecoveryPolicySaga_1 = require("../AutoRecovery/autoRecoveryPolicySaga");
function* devicePolicySaga() {
    yield (0, effects_1.all)([
        (0, deviceVolumePolicySagas_1.deviceVolumePolicySaga)(),
        (0, brightnessPolicySagas_1.deviceBrightnessPolicySaga)(),
        (0, deviceResolutionPolicySagas_1.deviceResolutionPolicySaga)(),
        (0, deviceOrientationPolicySagas_1.deviceOrientationPolicySaga)(),
        (0, deviceRemoteControlPolicySagas_1.deviceRemoteControlPolicySaga)(),
        (0, deviceApplicationPolicySagas_1.deviceApplicationPolicySaga)(),
        (0, deviceFirmwarePolicySagas_1.deviceFirmwarePolicySaga)(),
        (0, deviceDebugPolicySagas_1.deviceDebugPolicySaga)(),
        (0, deviceDateTimePolicySagas_1.deviceDateTimePolicySaga)(),
        (0, devicePowerActionPolicySagas_1.devicePowerActionPolicySaga)(),
        (0, deviceTimerPolicySagas_1.deviceTimerPolicySaga)(),
        (0, deviceTimerPolicySagas_1.deviceProprietaryTimerPolicySaga)(),
        (0, extendedManagementPolicySagas_1.deviceExtendedManagementPolicySaga)(),
        (0, peerRecoveryPolicySaga_1.devicePeerRecoveryPolicySaga)(),
        (0, autoRecoveryPolicySaga_1.deviceAutoRecoveryPolicySaga)(),
    ]);
}
exports.devicePolicySaga = devicePolicySaga;
//# sourceMappingURL=devicePolicySaga.js.map