"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.installPackageSaga = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const devicePackageActions_1 = require("@signageos/actions/dist/Device/Package/devicePackageActions");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const capable_1 = require("../../../Feature/capable");
const dependencyInjection_1 = require("../../../DI/dependencyInjection");
function* installPackageCallback(managementDriver, staticBaseUrl, action) {
    try {
        yield (0, effects_1.apply)(managementDriver, managementDriver.packageInstall, [staticBaseUrl, action.packageName, action.version, action.build]);
        yield (0, effects_1.put)({
            type: devicePackageActions_1.InstallPackageSucceeded,
            uid: action.uid,
        });
    }
    catch (error) {
        console.error('installPackageSaga', error);
        yield (0, effects_1.put)({
            type: devicePackageActions_1.InstallPackageFailed,
            uid: action.uid,
        });
    }
}
function* installPackageSaga(responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.PACKAGES)) {
        return;
    }
    yield (0, socketActionCreator_1.bindWhenPlatform)(devicePackageActions_1.InstallPackage);
    yield (0, effects_1.fork)((0, capable_1.whenCapable)(ManagementCapability_1.default.PACKAGE_INSTALL, (0, dependencyInjection_1.withDependencies)(['managementDriver', 'staticBaseUrl'], function* ({ managementDriver, staticBaseUrl }) {
        yield (0, effects_1.takeEvery)(devicePackageActions_1.InstallPackage, installPackageCallback, managementDriver, staticBaseUrl);
    })));
}
exports.installPackageSaga = installPackageSaga;
//# sourceMappingURL=devicePackageSagas.js.map