"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const checksum_1 = require("../../../Hash/checksum");
const ipAddressHelper_1 = require("../../../NativeDevice/Network/ipAddressHelper");
class MockNetwork {
    constructor(window) {
        this.window = window;
        this.ifaces = [];
    }
    listInterfaces() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.ensureInterfaces();
            return this.ifaces;
        });
    }
    setManual(ifaceName, options) {
        return __awaiter(this, void 0, void 0, function* () {
            console.info('Emulated setManual for interface ' + ifaceName, options);
            this.setInterfaceDisabled(ifaceName, false);
        });
    }
    setDHCP(ifaceName) {
        return __awaiter(this, void 0, void 0, function* () {
            console.info('Emulated setDHCP for interface ' + ifaceName);
            this.setInterfaceDisabled(ifaceName, false);
        });
    }
    disableInterface(ifaceName) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.ensureInterfaces();
            this.setInterfaceDisabled(ifaceName, true);
        });
    }
    setInterfaceDisabled(ifaceName, disabled) {
        for (const iface of this.ifaces) {
            if (iface.name === ifaceName) {
                iface.disabled = disabled;
            }
        }
    }
    ensureInterfaces() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.ifaces.length === 0) {
                this.ifaces = yield Promise.all([this.generateInterfaceInfo('ethernet'), this.generateInterfaceInfo('wifi')]);
            }
        });
    }
    generateInterfaceInfo(type) {
        return __awaiter(this, void 0, void 0, function* () {
            const localAddress = yield this.getIPAddress();
            switch (type) {
                case 'ethernet':
                    return {
                        type,
                        name: 'eth0',
                        localAddress,
                        macAddress: this.generateMacAddress(20),
                        gateway: this.getGateway(localAddress),
                        netmask: '',
                        dns: [],
                    };
                case 'wifi':
                    return {
                        type,
                        name: 'wlan0',
                        localAddress,
                        macAddress: this.generateMacAddress(15),
                        gateway: this.getGateway(localAddress),
                        netmask: '',
                        dns: [],
                        wifiStrength: 100,
                        wifiSsid: 'SignageOS',
                    };
                default:
                    throw new Error('Unknown network interface type');
            }
        });
    }
    generateMacAddress(random) {
        return (0, checksum_1.checksumString)((0, checksum_1.checksumString)(this.window.navigator.userAgent, random), 12)
            .match(/.{1,2}/g)
            .join(':');
    }
    getIPAddress() {
        return __awaiter(this, void 0, void 0, function* () {
            const localIpAddresses = yield (0, ipAddressHelper_1.getLocalIpAddresses)();
            return localIpAddresses.length > 0 ? localIpAddresses[0] : '192.168.1.113';
        });
    }
    getGateway(ipAddress) {
        const maskedIpAddress = ipAddress.split('.');
        maskedIpAddress.pop();
        return maskedIpAddress.join('.') + '.1'; // only fake gateway number
    }
}
exports.default = MockNetwork;
//# sourceMappingURL=MockNetwork.js.map