"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceFirmwareUpgrade = exports.deviceFirmwareNotify = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const deviceFirmwareActions_1 = require("@signageos/actions/dist/Device/Firmware/deviceFirmwareActions");
const authenticationActions_1 = require("@signageos/actions/dist/Authentication/authenticationActions");
const channels_1 = require("../../../ReduxSaga/channels");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const capable_1 = require("../../../Feature/capable");
const dependencyInjection_1 = require("../../../DI/dependencyInjection");
const processCallback_1 = __importDefault(require("../../../Util/processCallback"));
const deviceFirmwareVersionUpgradeStart = (progressChannel, getDeviceUid) => (0, capable_1.whenCapable)(ManagementCapability_1.default.FIRMWARE_UPGRADE, (0, dependencyInjection_1.withDependencies)(['managementDriver', 'staticBaseUrl'], function* ({ managementDriver, staticBaseUrl }, action) {
    yield (0, effects_1.fork)(deviceFirmwareVersionUpgradeProgress, action.uid, progressChannel);
    try {
        yield (0, effects_1.put)({
            type: deviceFirmwareActions_1.UpgradeDeviceFirmwareVersionStarted,
            uid: action.uid,
        });
        const finalizeCallback = yield (0, effects_1.call)([managementDriver, managementDriver.firmwareUpgrade], staticBaseUrl, action.version, (progress) => progressChannel.put({ progress }));
        yield (0, effects_1.call)(checkVersion(getDeviceUid));
        yield (0, effects_1.call)(processCallback_1.default, finalizeCallback);
    }
    catch (error) {
        console.error(error);
        yield (0, effects_1.put)({
            type: deviceFirmwareActions_1.UpgradeDeviceFirmwareVersionFailed,
            uid: action.uid,
        });
    }
}));
function* deviceFirmwareNotify(responsibilities, getDeviceUid) {
    if (!responsibilities.has(Responsibility_1.default.FIRMWARE)) {
        return;
    }
    yield (0, socketActionCreator_1.bindAndTakeEvery)(authenticationActions_1.AuthenticationSucceed, checkVersion(getDeviceUid));
    yield (0, socketActionCreator_1.bindAndTakeEvery)(authenticationActions_1.AuthenticationSucceed, notifyFirmwareType);
}
exports.deviceFirmwareNotify = deviceFirmwareNotify;
function* deviceFirmwareUpgrade(responsibilities, getDeviceUid) {
    if (!responsibilities.has(Responsibility_1.default.FIRMWARE)) {
        return;
    }
    const progressChannel = (0, channels_1.createChannel)();
    yield (0, socketActionCreator_1.bindAndTakeEvery)(deviceFirmwareActions_1.UpgradeDeviceFirmwareVersion, function* (action) {
        yield (0, effects_1.fork)(deviceFirmwareVersionUpgradeStart(progressChannel, getDeviceUid), action);
    });
}
exports.deviceFirmwareUpgrade = deviceFirmwareUpgrade;
function* deviceFirmwareVersionUpgradeProgress(uid, progressChannel) {
    yield (0, channels_1.takeEvery)(progressChannel, function* ({ progress }) {
        try {
            yield (0, effects_1.put)({
                type: deviceFirmwareActions_1.UpgradeDeviceFirmwareVersionProgressed,
                uid,
                progress,
            });
        }
        catch (error) {
            console.error('deviceFirmwareVersionUpgradeProgress', error);
        }
    });
}
const checkVersion = (getDeviceUid) => function* () {
    try {
        const deviceUid = yield (0, effects_1.call)(getDeviceUid);
        const { managementDriver } = yield (0, dependencyInjection_1.awaitDependencies)(['managementDriver']);
        const version = yield (0, effects_1.call)([managementDriver, managementDriver.firmwareGetVersion]);
        yield (0, effects_1.put)({
            type: deviceFirmwareActions_1.NotifyDeviceFirmwareVersion,
            deviceUid,
            version,
        });
    }
    catch (error) {
        console.error('deviceFirmwareVersionNotify failed', error);
    }
};
const notifyFirmwareType = function* () {
    try {
        const { managementDriver } = yield (0, dependencyInjection_1.awaitDependencies)(['managementDriver']);
        const firmwareType = yield (0, effects_1.call)([managementDriver, managementDriver.firmwareGetType]);
        if (firmwareType) {
            yield (0, effects_1.put)({
                type: deviceFirmwareActions_1.NotifyDeviceFirmwareType,
                firmwareType,
            });
        }
    }
    catch (error) {
        console.error('notifyFirmwareType failed', error);
    }
};
//# sourceMappingURL=deviceFirmwareSagas.js.map