"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceDeprovision = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const deviceDeprovisionActions_1 = require("@signageos/actions/dist/Device/Deprovision/deviceDeprovisionActions");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const object_1 = require("@signageos/lib/dist/Utils/object");
const TimerType_1 = __importDefault(require("../../../NativeDevice/Timer/TimerType"));
const combinedDriver_1 = require("../../../NativeDevice/Default/combinedDriver");
function* deviceDeprovision(getNativeDriver, responsibilities, sessionIdKey) {
    if (responsibilities.has(Responsibility_1.default.DEPROVISIONING)) {
        yield (0, socketActionCreator_1.takeEveryAndBindWhenPlatform)(deviceDeprovisionActions_1.PerformDeviceDeprovision, function* () {
            try {
                let { managementDriver } = (0, combinedDriver_1.normalizeManagementCacheDriver)(getNativeDriver());
                yield Promise.allSettled([
                    clearCache(() => (0, combinedDriver_1.normalizeManagementCacheDriver)(getNativeDriver()).cacheDriver),
                    clearFileSystem(() => (0, combinedDriver_1.normalizeManagementCacheDriver)(getNativeDriver()).managementDriver),
                    managementDriver.remoteControlSetEnabled(true),
                    clearTimers(() => (0, combinedDriver_1.normalizeManagementCacheDriver)(getNativeDriver()).managementDriver),
                    managementDriver.setSessionId(sessionIdKey, ''),
                    managementDriver.screenSetBrightness('00:00', 50, '00:00', 50),
                    managementDriver.setVolume(50),
                    managementDriver.displayPowerOn(),
                    managementDriver.setDebug(false),
                ]);
                yield (0, wait_1.default)(60e3); // wait until front saga is 100% also done
                yield (0, combinedDriver_1.normalizeManagementCacheDriver)(getNativeDriver()).managementDriver.systemReboot();
            }
            catch (error) {
                console.error('deviceDeprovision failed', error);
            }
        });
    }
}
exports.deviceDeprovision = deviceDeprovision;
function clearCache(getNativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const uids = yield getNativeDriver().cacheGetUids();
        yield Promise.allSettled(uids.map((uid) => __awaiter(this, void 0, void 0, function* () {
            yield getNativeDriver().cacheDelete(uid);
        })));
    });
}
function clearFileSystem(getNativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const storageUnits = yield getNativeDriver().fileSystem.listStorageUnits();
        const internalStorageUnits = storageUnits.filter((su) => !su.removable);
        yield Promise.allSettled(internalStorageUnits.map((storageUnit) => __awaiter(this, void 0, void 0, function* () {
            const filePaths = yield getNativeDriver().fileSystem.listFiles({ storageUnit, filePath: '' });
            yield Promise.allSettled(filePaths.map((filePath) => __awaiter(this, void 0, void 0, function* () {
                yield getNativeDriver().fileSystem.deleteFile(filePath, true);
            })));
        })));
    });
}
function clearTimers(getNativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield Promise.allSettled((0, object_1.getObjectKeys)(TimerType_1.default).map((timerTypeString) => __awaiter(this, void 0, void 0, function* () {
            yield getNativeDriver().setTimer(TimerType_1.default[timerTypeString], null, null, [], 0);
        })));
    });
}
//# sourceMappingURL=deviceDeprovisionSagas.js.map