"use strict";
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkAndSetDateTimeSettings = exports.deviceDateTimePolicySaga = void 0;
const moment_timezone_1 = __importDefault(require("moment-timezone"));
const DeviceSettingsType_1 = require("@signageos/common-types/dist/Device/Settings/DeviceSettingsType");
const devicePolicySagas_1 = require("../Policy/devicePolicySagas");
const deviceDateTimeTelemetrySagas_1 = require("./deviceDateTimeTelemetrySagas");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const debug_1 = __importDefault(require("debug"));
const processCallback_1 = __importDefault(require("../../../Util/processCallback"));
const debug = (0, debug_1.default)('@signageos/front-display:Management:Policy:DateTime');
exports.deviceDateTimePolicySaga = (0, devicePolicySagas_1.createDevicePolicySaga)(DeviceSettingsType_1.DeviceSettingsType.DATETIME, Responsibility_1.default.TIME, ManagementCapability_1.default.SET_TIMEZONE, checkAndSetDateTimeSettings);
function checkAndSetDateTimeSettings(properties) {
    var _a, _b;
    return __asyncGenerator(this, arguments, function* checkAndSetDateTimeSettings_1() {
        const preferredSettings = properties.policy.value;
        const currentSettings = yield __await((0, deviceDateTimeTelemetrySagas_1.getDateTimeSettings)(properties));
        const newSettings = {
            ntpServer: (_a = preferredSettings.ntpServer) !== null && _a !== void 0 ? _a : currentSettings.ntpServer,
            timezone: (_b = preferredSettings.timezone) !== null && _b !== void 0 ? _b : currentSettings.timezone,
        };
        const offsetNewTimezone = newSettings.timezone === null ? null : (0, moment_timezone_1.default)().tz(newSettings.timezone).utcOffset();
        const offsetCurrentTimezone = currentSettings.timezone === null ? null : (0, moment_timezone_1.default)().tz(currentSettings.timezone).utcOffset();
        const formattedNewNtp = newSettings.ntpServer === null ? null : newSettings.ntpServer.toLowerCase();
        const formattedCurrentNtp = currentSettings.ntpServer === null ? null : currentSettings.ntpServer.toLowerCase();
        const isSettingsChanged = offsetNewTimezone !== offsetCurrentTimezone || formattedNewNtp !== formattedCurrentNtp;
        debug('Datetime comparsion timezone offset proposed %d with current %d', offsetNewTimezone, offsetCurrentTimezone);
        if (newSettings.timezone && isSettingsChanged) {
            let finalizeCallback;
            if (formattedNewNtp) {
                debug('time manger setAuto method will be called');
                finalizeCallback = yield __await(properties.managementDriver.timeManager.setAuto(formattedNewNtp, newSettings.timezone));
            }
            else {
                debug('time manager setManual method will be called');
                finalizeCallback = yield __await(properties.managementDriver.timeManager.setManual(new Date().valueOf(), newSettings.timezone));
            }
            (0, processCallback_1.default)(finalizeCallback);
            return yield __await(devicePolicySagas_1.CheckAndSetResult.CHANGED);
        }
        return yield __await(devicePolicySagas_1.CheckAndSetResult.NOT_CHANGED);
    });
}
exports.checkAndSetDateTimeSettings = checkAndSetDateTimeSettings;
//# sourceMappingURL=deviceDateTimePolicySagas.js.map