import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import { TimeManagerFinalizeCallback } from '../../../NativeDevice/TimeManager/ITimeManager';
export interface ITimeWithTimezone {
    timestamp: number;
    timezone: string | null;
    /**
     * Offset is POSIX based. A negative offset indicates a time zone east of the Prime Meridian.
     * A positive offset indicates the time zone west of the Prime Meridian.
     */
    timezoneOffset: number;
    ntpServer?: string;
    /**
     * Some webos version can not set ntpServer, instead we can set ntpEnabled which set auto clock on display.
     */
    ntpEnabled?: boolean;
}
export declare function setNtpOrManualTime(nativeDriver: IManagementDriver, timestampMs: number, timezone: string, ntpServer?: string): Promise<TimeManagerFinalizeCallback>;
export declare function getCurrentTime(nativeDriver: IManagementDriver): Promise<ITimeWithTimezone>;
