"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.startupDeviceDateTimeSettings = exports.updateTimeSettingsSaga = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const deviceDateTimeActions_1 = require("@signageos/actions/dist/Device/DateTime/deviceDateTimeActions");
const authenticationActions_1 = require("@signageos/actions/dist/Authentication/authenticationActions");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const dateTimeFacade_1 = require("./dateTimeFacade");
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const currentTimeSyncSagas_1 = require("../../../Device/DateTime/currentTimeSyncSagas");
const dependencyInjection_1 = require("../../../DI/dependencyInjection");
const responsible_1 = require("../../../Feature/responsible");
const capable_1 = require("../../../Feature/capable");
const timeChangeDetector_1 = require("../../../DateTime/timeChangeDetector");
const channels_1 = require("../../../ReduxSaga/channels");
const applicationActions_1 = require("../../../Application/applicationActions");
const processCallback_1 = __importDefault(require("../../../Util/processCallback"));
const TIME_NOTIFY_INTERVAL_MS = 30e3;
const TIME_NOTIFY_THRESHOLD_MS = 60e3;
exports.updateTimeSettingsSaga = (0, responsible_1.whenResponsible)(Responsibility_1.default.TIME, (0, capable_1.whenCapable)(ManagementCapability_1.default.SET_TIME, (0, dependencyInjection_1.withDependencies)(['managementDriver', 'propertyStorage'], function* ({ managementDriver }) {
    yield (0, socketActionCreator_1.bindAndTakeEveryOnlyWhenPlatform)(deviceDateTimeActions_1.UpdateDeviceTimeSettings, function* (action) {
        try {
            const finalizeCallback = yield (0, effects_1.call)(dateTimeFacade_1.setNtpOrManualTime, managementDriver, action.timestamp, action.timezone, action.ntpServer);
            yield (0, effects_1.put)({
                type: deviceDateTimeActions_1.UpdateDeviceTimeSettingsSucceed,
                uid: action.uid,
            });
            yield (0, effects_1.fork)(currentTimeSyncSagas_1.notifyCurrentTime);
            yield (0, effects_1.call)(processCallback_1.default, finalizeCallback);
        }
        catch (error) {
            console.error('updateTimeSettingsSage failed', error);
            yield (0, effects_1.put)({
                type: deviceDateTimeActions_1.UpdateDeviceTimeSettingsFailed,
                uid: action.uid,
            });
        }
    });
})));
const updatingTimeWhenChanged = function* () {
    yield (0, effects_1.call)(takeEverySignificantTimeChange, function* () {
        yield (0, effects_1.call)(currentTimeSyncSagas_1.notifyCurrentTime);
    });
};
exports.startupDeviceDateTimeSettings = (0, responsible_1.whenResponsible)(Responsibility_1.default.TIME, function* () {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(authenticationActions_1.AuthenticationSucceed, currentTimeSyncSagas_1.notifyCurrentTime);
    yield (0, effects_1.fork)(updatingTimeWhenChanged);
});
const takeEverySignificantTimeChange = (0, dependencyInjection_1.withDependencies)(['managementDriver', 'propertyStorage'], function* ({ managementDriver }, saga) {
    const timeChangeDetector = new timeChangeDetector_1.TimeChangeDetector(managementDriver, TIME_NOTIFY_INTERVAL_MS, TIME_NOTIFY_THRESHOLD_MS);
    const changesChannel = (0, channels_1.createChannel)((thisPut) => timeChangeDetector.start(() => thisPut()));
    try {
        yield (0, effects_1.call)(channels_1.takeEvery, changesChannel, saga);
        yield (0, effects_1.take)(applicationActions_1.StopApplication);
    }
    finally {
        timeChangeDetector.stop();
    }
});
//# sourceMappingURL=currentTimeSyncSagas.js.map