"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.telemetryDeviceBundledAppletSaga = exports.getBundledAppletInfo = void 0;
const DeviceTelemetryType_1 = require("@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType");
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const deviceTelemetrySagas_1 = require("../Telemetry/deviceTelemetrySagas");
const dependencyInjection_1 = require("../../../DI/dependencyInjection");
function* getBundledAppletInfo() {
    var _a;
    let bundledAppletInfo = null;
    const { bundledApplet: bundledApplet } = yield (0, dependencyInjection_1.awaitDependencies)(['bundledApplet']);
    bundledAppletInfo = bundledApplet;
    if (!bundledAppletInfo) {
        return null;
    }
    return {
        appletUid: bundledAppletInfo.uid,
        appletVersion: bundledAppletInfo.version,
        config: (_a = bundledAppletInfo.config) !== null && _a !== void 0 ? _a : {},
    };
}
exports.getBundledAppletInfo = getBundledAppletInfo;
exports.telemetryDeviceBundledAppletSaga = (0, deviceTelemetrySagas_1.createDeviceTelemetrySaga)(DeviceTelemetryType_1.DeviceTelemetryType.BUNDLED_APPLET, Responsibility_1.default.BUNDLED_APPLET, [], function* () {
    return yield* getBundledAppletInfo();
});
//# sourceMappingURL=deviceBundledAppletTelemetrySagas.js.map