"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.syncBrightnessSettingsSaga = exports.setDeviceBrightnessCallback = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const deviceBrightnessActions_1 = require("@signageos/actions/dist/Device/Brightness/deviceBrightnessActions");
const Property_1 = __importDefault(require("../../../Property/Property"));
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
function* setDeviceBrightnessCallback(getNativeDriver, propertyStorage, action) {
    try {
        const nativeDriver = getNativeDriver();
        yield (0, effects_1.apply)(nativeDriver, nativeDriver.screenSetBrightness, [
            action.timeFrom1,
            action.brightness1,
            action.timeFrom2,
            action.brightness2,
        ]);
        yield (0, effects_1.apply)(propertyStorage, propertyStorage.setValue, [
            Property_1.default.BRIGHTNESS_SETTINGS,
            {
                timeFrom1: action.timeFrom1,
                brightness1: action.brightness1,
                timeFrom2: action.timeFrom2,
                brightness2: action.brightness2,
            },
        ]);
        yield (0, effects_1.put)({
            type: deviceBrightnessActions_1.SetDeviceBrightnessSucceeded,
            uid: action.uid,
        });
    }
    catch (error) {
        console.error('syncBrightnessSettingsSaga', error);
        yield (0, effects_1.put)({
            type: deviceBrightnessActions_1.SetDeviceBrightnessFailed,
            uid: action.uid,
        });
    }
}
exports.setDeviceBrightnessCallback = setDeviceBrightnessCallback;
function* syncBrightnessSettingsSaga(getNativeDriver, responsibilities, propertyStorage) {
    if (!responsibilities.has(Responsibility_1.default.BRIGHTNESS)) {
        return;
    }
    yield (0, socketActionCreator_1.bindWhenPlatform)(deviceBrightnessActions_1.SetDeviceBrightness);
    const supportsBrightness = yield getNativeDriver().managementSupports(ManagementCapability_1.default.SET_BRIGHTNESS);
    if (supportsBrightness) {
        yield (0, effects_1.takeEvery)(deviceBrightnessActions_1.SetDeviceBrightness, setDeviceBrightnessCallback, getNativeDriver, propertyStorage);
    }
}
exports.syncBrightnessSettingsSaga = syncBrightnessSettingsSaga;
//# sourceMappingURL=deviceBrightnessSagas.js.map