"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBrightnessSettings = exports.telemetryBrightnessSettingsSaga = void 0;
const deviceTelemetrySagas_1 = require("../Telemetry/deviceTelemetrySagas");
const DeviceTelemetryType_1 = require("@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType");
const screenHelper_1 = require("../../../NativeDevice/Screen/screenHelper");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
exports.telemetryBrightnessSettingsSaga = (0, deviceTelemetrySagas_1.createDeviceTelemetrySaga)(DeviceTelemetryType_1.DeviceTelemetryType.BRIGHTNESS, Responsibility_1.default.BRIGHTNESS, [ManagementCapability_1.default.GET_BRIGHTNESS], getBrightnessSettings);
function getBrightnessSettings({ managementDriver }, time = new Date()) {
    return __awaiter(this, void 0, void 0, function* () {
        const { timeFrom1, brightness1, timeFrom2, brightness2 } = yield managementDriver.screenGetBrightness();
        return {
            brightness: (0, screenHelper_1.resolveCurrentBrightness)(timeFrom1, brightness1, timeFrom2, brightness2, time),
        };
    });
}
exports.getBrightnessSettings = getBrightnessSettings;
//# sourceMappingURL=brightnessTelemetrySagas.js.map