"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.brightnessRefresh = void 0;
const effects_1 = require("redux-saga/effects");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const dateTimeFactory_1 = require("@signageos/lib/dist/DateTime/dateTimeFactory");
const screenHelper_1 = require("../../../NativeDevice/Screen/screenHelper");
const Property_1 = __importDefault(require("../../../Property/Property"));
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
function* brightnessRefresh(getNativeDriver, propertyStorage) {
    // only start this process if the device doesn't support brightness schedule natively
    const isSupported = yield getNativeDriver().managementSupports(ManagementCapability_1.default.BRIGHTNESS_SCHEDULING);
    if (!isSupported) {
        yield (0, effects_1.fork)(function* () {
            while (true) {
                yield (0, wait_1.default)(30 * 1e3);
                try {
                    const now = (0, dateTimeFactory_1.now)().toDate();
                    yield refreshBrightness(getNativeDriver(), propertyStorage, now);
                }
                catch (error) {
                    console.error('brightness refresh failed', error);
                }
            }
        });
    }
}
exports.brightnessRefresh = brightnessRefresh;
function* refreshBrightness(nativeDriver, propertyStorage, now) {
    const settings = yield propertyStorage.getValueOrDefault(Property_1.default.BRIGHTNESS_SETTINGS, null);
    if (settings) {
        const newBrightness = (0, screenHelper_1.resolveCurrentBrightness)(settings.timeFrom1, settings.brightness1, settings.timeFrom2, settings.brightness2, now);
        const oldBrightnessSettings = yield nativeDriver.screenGetBrightness();
        const oldBrightness = (0, screenHelper_1.resolveCurrentBrightness)(oldBrightnessSettings.timeFrom1, oldBrightnessSettings.brightness1, oldBrightnessSettings.timeFrom2, oldBrightnessSettings.brightness2, now);
        if (oldBrightness !== newBrightness) {
            yield (0, effects_1.apply)(nativeDriver, nativeDriver.screenSetBrightness, [settings.timeFrom1, newBrightness, settings.timeFrom2, newBrightness]);
        }
    }
}
//# sourceMappingURL=brightnessControllerSagas.js.map