"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceVolumeSaga = exports.setDeviceVolumeCallback = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const deviceAudioActions_1 = require("@signageos/actions/dist/Device/Audio/deviceAudioActions");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
function* setDeviceVolumeCallback(getNativeDriver, action) {
    try {
        const nativeDriver = getNativeDriver();
        yield (0, effects_1.apply)(nativeDriver, nativeDriver.setVolume, [action.volume]);
        yield (0, effects_1.put)({
            type: deviceAudioActions_1.SetDeviceVolumeSucceeded,
            uid: action.uid,
        });
    }
    catch (error) {
        console.error('deviceVolumeSaga', error);
        yield (0, effects_1.put)({
            type: deviceAudioActions_1.SetDeviceVolumeFailed,
            uid: action.uid,
        });
    }
}
exports.setDeviceVolumeCallback = setDeviceVolumeCallback;
function* deviceVolumeSaga(getNativeDriver, responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.VOLUME)) {
        return;
    }
    yield (0, socketActionCreator_1.bindWhenPlatform)(deviceAudioActions_1.SetDeviceVolume);
    const supportsVolume = yield getNativeDriver().managementSupports(ManagementCapability_1.default.SET_VOLUME);
    if (supportsVolume) {
        yield (0, effects_1.takeEvery)(deviceAudioActions_1.SetDeviceVolume, setDeviceVolumeCallback, getNativeDriver);
    }
}
exports.deviceVolumeSaga = deviceVolumeSaga;
//# sourceMappingURL=deviceVolumeSagas.js.map