"use strict";
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkAndSetVolumeSettings = exports.deviceVolumePolicySaga = void 0;
const DeviceSettingsType_1 = require("@signageos/common-types/dist/Device/Settings/DeviceSettingsType");
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const devicePolicySagas_1 = require("../Policy/devicePolicySagas");
const deviceVolumeTelemetrySagas_1 = require("./deviceVolumeTelemetrySagas");
exports.deviceVolumePolicySaga = (0, devicePolicySagas_1.createDevicePolicySaga)(DeviceSettingsType_1.DeviceSettingsType.VOLUME, Responsibility_1.default.VOLUME, ManagementCapability_1.default.SET_VOLUME, checkAndSetVolumeSettings);
function checkAndSetVolumeSettings(properties) {
    return __asyncGenerator(this, arguments, function* checkAndSetVolumeSettings_1() {
        const volumeSettings = properties.policy.value;
        const currentVolumeSettings = yield __await((0, deviceVolumeTelemetrySagas_1.getVolumeSettings)(properties));
        if (volumeSettings.volume !== currentVolumeSettings.volume) {
            yield __await(properties.managementDriver.setVolume(volumeSettings.volume));
            return yield __await(devicePolicySagas_1.CheckAndSetResult.CHANGED);
        }
        return yield __await(devicePolicySagas_1.CheckAndSetResult.NOT_CHANGED);
    });
}
exports.checkAndSetVolumeSettings = checkAndSetVolumeSettings;
//# sourceMappingURL=deviceVolumePolicySagas.js.map