"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.syncApplicationVersionSaga = exports.setDeviceApplicationVersionCallback = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const deviceApplicationActions_1 = require("@signageos/actions/dist/Device/Application/deviceApplicationActions");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const capable_1 = require("../../../Feature/capable");
const dependencyInjection_1 = require("../../../DI/dependencyInjection");
const processCallback_1 = __importDefault(require("../../../Util/processCallback"));
function* setDeviceApplicationVersionCallback(managementDriver, staticBaseUrl, action) {
    try {
        const finalizeCallback = yield (0, effects_1.apply)(managementDriver, managementDriver.appUpgrade, [staticBaseUrl, action.version]);
        yield (0, effects_1.put)({
            type: deviceApplicationActions_1.SetDeviceApplicationVersionSucceeded,
            uid: action.uid,
        });
        yield (0, effects_1.call)(processCallback_1.default, finalizeCallback);
    }
    catch (error) {
        console.error('syncApplicationVersionSaga', error);
        yield (0, effects_1.put)({
            type: deviceApplicationActions_1.SetDeviceApplicationVersionFailed,
            uid: action.uid,
        });
    }
}
exports.setDeviceApplicationVersionCallback = setDeviceApplicationVersionCallback;
function* syncApplicationVersionSaga(responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.APP)) {
        return;
    }
    yield (0, socketActionCreator_1.bindWhenPlatform)(deviceApplicationActions_1.SetDeviceApplicationVersion);
    yield (0, effects_1.fork)((0, capable_1.whenCapable)(ManagementCapability_1.default.APP_UPGRADE, (0, dependencyInjection_1.withDependencies)(['managementDriver', 'staticBaseUrl'], function* ({ managementDriver, staticBaseUrl }) {
        yield (0, effects_1.takeEvery)(deviceApplicationActions_1.SetDeviceApplicationVersion, setDeviceApplicationVersionCallback, managementDriver, staticBaseUrl);
    })));
}
exports.syncApplicationVersionSaga = syncApplicationVersionSaga;
//# sourceMappingURL=deviceApplicationSagas.js.map