"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useRavenLogging = void 0;
const raven_js_1 = __importDefault(require("raven-js"));
function useRavenLogging(window) {
    // override default console logging
    const consoleError = console.error;
    console.error = (...args) => {
        consoleError.call(console, ...args);
        captureRaven('error', 'error', ...args);
    };
    window.onunhandledrejection = ({ promise, reason }) => console.error(reason, promise);
}
exports.useRavenLogging = useRavenLogging;
function captureRaven(level, source, ...args) {
    const options = {
        level,
        tags: {
            source,
        },
        extra: null,
    };
    const exception = args.find((arg) => arg instanceof Error);
    if (exception) {
        options.extra = args.filter((arg) => arg !== exception);
        raven_js_1.default.captureException(exception, options);
    }
    else {
        let message = args[0];
        if (typeof message !== 'string') {
            message = JSON.stringify(message);
        }
        raven_js_1.default.captureMessage(message, options);
    }
}
//# sourceMappingURL=logger.js.map