"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.synchronous = void 0;
const async_lock_1 = __importDefault(require("async-lock"));
const circular_json_1 = __importDefault(require("circular-json"));
function synchronous(options) {
    const asyncLock = new async_lock_1.default(options);
    return function (_target, propertyKey, descriptor) {
        const originalMethod = descriptor.value;
        descriptor.value = function (...args) {
            return asyncLock.acquire(propertyKey, () => __awaiter(this, void 0, void 0, function* () {
                const returnValuePromise = originalMethod.apply(this, args);
                if (!(returnValuePromise instanceof Promise)) {
                    throw new Error(`Synchronous methods must return Promise instance. But ${circular_json_1.default.stringify(returnValuePromise)} given.`);
                }
                const returnValue = yield returnValuePromise;
                return returnValue;
            }));
        };
    };
}
exports.synchronous = synchronous;
//# sourceMappingURL=synchronousDecorator.js.map