"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.locked = void 0;
const async_lock_1 = __importDefault(require("async-lock"));
const circular_json_1 = __importDefault(require("circular-json"));
const asyncLock = new async_lock_1.default();
function locked(key, options) {
    return function (_target, _propertyKey, descriptor) {
        const originalMethod = descriptor.value;
        descriptor.value = function (...args) {
            return asyncLock.acquire(key, () => __awaiter(this, void 0, void 0, function* () {
                const returnValuePromise = originalMethod.apply(this, args);
                if (!(returnValuePromise instanceof Promise)) {
                    throw new Error(`Synchronous methods must return Promise instance. But ${circular_json_1.default.stringify(returnValuePromise)} given.`);
                }
                return yield returnValuePromise;
            }), options);
        };
    };
}
exports.locked = locked;
//# sourceMappingURL=lockedDecorator.js.map