"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Headers = exports.Request = exports.Response = exports.fetch = void 0;
const node_fetch_1 = __importStar(require("node-fetch")), nodeFetchExports = node_fetch_1;
const globalThis_1 = __importDefault(require("../ponyfill/globalThis"));
/*
    Perform condition select fetch according to environment setting from  webpack.DefinePlugin
    For apps running in brows it select window.fetch and for apps using node it require node-fetch
    It is dependent on process.env.ISOMORPHIC_TARGET in webpack.config.ts in each core app
 */
function fetch(url, init) {
    return __awaiter(this, void 0, void 0, function* () {
        if (process.env.ISOMORPHIC_TARGET === 'node') {
            const response = yield (0, node_fetch_1.default)(url, init);
            return response;
        }
        else {
            return yield globalThis_1.default.fetch(url, init);
        }
    });
}
exports.fetch = fetch;
exports.Response = process.env.ISOMORPHIC_TARGET === 'node' ? nodeFetchExports.Response : globalThis_1.default.Response;
exports.Request = process.env.ISOMORPHIC_TARGET === 'node' ? nodeFetchExports.Request : globalThis_1.default.Request;
exports.Headers = process.env.ISOMORPHIC_TARGET === 'node' ? nodeFetchExports.Headers : globalThis_1.default.Headers;
//# sourceMappingURL=fetch.js.map