"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProprietaryInput = void 0;
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/front-display:Input:ProprietaryInput');
class ProprietaryInput {
    constructor(window) {
        this.window = window;
    }
    dispatchEvent(event) {
        return __awaiter(this, void 0, void 0, function* () {
            debug('dispatchEvent', { event });
            if (isMouseEventPayload(event)) {
                let view = this.window;
                let element = this.window.document.elementFromPoint(event.x, event.y);
                // Go through iframes to the deepest element
                while (isHTMLIframeElement(element) && element.contentWindow) {
                    event = Object.assign(Object.assign({}, event), { x: event.x - element.offsetLeft, y: event.y - element.offsetTop });
                    view = element.contentWindow;
                    element = element.contentWindow.document.elementFromPoint(event.x, event.y);
                }
                const effective = element === null || element === void 0 ? void 0 : element.dispatchEvent(new MouseEvent(event.type, {
                    view,
                    bubbles: true,
                    cancelable: true,
                    clientX: event.x,
                    clientY: event.y,
                }));
                debug('dispatchEvent', { event, effective });
            }
        });
    }
}
exports.ProprietaryInput = ProprietaryInput;
function isHTMLIframeElement(element) {
    return (element === null || element === void 0 ? void 0 : element.tagName) === 'IFRAME';
}
function isMouseEventPayload(event) {
    return ('type' in event &&
        typeof event.type === 'string' &&
        'x' in event &&
        typeof event.x === 'number' &&
        'y' in event &&
        typeof event.y === 'number');
}
//# sourceMappingURL=ProprietaryInput.js.map