"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const IWifi_1 = require("../../NativeDevice/Hardware/IWifi");
const MockWifiDevice_1 = __importDefault(require("./MockWifiDevice"));
const IntegerGenerator_1 = require("./utils/IntegerGenerator");
const wifiDevices = [
    new MockWifiDevice_1.default('School', true, 100, 'uni12345', 'WPA2 Enterprise'),
    new MockWifiDevice_1.default('Work', true, 80, 'happy1234', 'WPA2 Enterprise'),
    new MockWifiDevice_1.default('BrownsWifi', false, 75),
    new MockWifiDevice_1.default('SmithsWifi', true, 60, 'unsecure9876', 'WEP'),
    new MockWifiDevice_1.default('JaneAndroid', true, 50, 'hihi5678', 'WPA2 Personal'),
    new MockWifiDevice_1.default("Chris's Phone", true, 40, 'hello5678', 'WPA'),
];
var WIFI_HW_STATE;
(function (WIFI_HW_STATE) {
    WIFI_HW_STATE[WIFI_HW_STATE["CLIENT"] = 0] = "CLIENT";
    WIFI_HW_STATE[WIFI_HW_STATE["AP"] = 1] = "AP";
    WIFI_HW_STATE[WIFI_HW_STATE["DISABLED"] = 2] = "DISABLED";
})(WIFI_HW_STATE || (WIFI_HW_STATE = {}));
class MockWifi {
    constructor() {
        this.wifiState = WIFI_HW_STATE.DISABLED;
        this.numberOfWifiScans = 0;
        this.countryCode = null;
        this.eventEmitter = new events_1.EventEmitter();
    }
    enableClient() {
        return __awaiter(this, void 0, void 0, function* () {
            this.wifiState = WIFI_HW_STATE.CLIENT;
            this.eventEmitter.emit(IWifi_1.WifiEvent.CLIENT_ENABLED);
        });
    }
    disable() {
        return __awaiter(this, void 0, void 0, function* () {
            this.wifiState = WIFI_HW_STATE.DISABLED;
            this.eventEmitter.emit(IWifi_1.WifiEvent.DISABLED);
        });
    }
    enableAP(_ssid, _passphrase) {
        return __awaiter(this, void 0, void 0, function* () {
            this.wifiState = WIFI_HW_STATE.AP;
            this.eventEmitter.emit(IWifi_1.WifiEvent.AP_ENABLED);
        });
    }
    isClientEnabled() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.wifiState === WIFI_HW_STATE.CLIENT;
        });
    }
    isAPEnabled() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.wifiState === WIFI_HW_STATE.AP;
        });
    }
    connect(_ssid, _password, _options) {
        return __awaiter(this, void 0, void 0, function* () {
            //password has to be between 8 and 63 characters
            if (_password && _password.length < 8 && _password.length > 63) {
                throw new Error('connection failed');
            }
            else {
                //simulating actual reaching the network, can happen it won't be reachable
                const devices = this.getWifiDevices();
                const filteredDevices = devices.filter((device) => device.ssid === _ssid);
                //in reality the wifi with better signal strength is chosen, I chose the first one
                if (filteredDevices.length > 0 && (yield filteredDevices[0].connect(_password))) {
                    this.networkDetail = new MockWifiDevice_1.default(_ssid, _password ? true : false, 100, _password);
                    this.eventEmitter.emit(IWifi_1.WifiEvent.CLIENT_CONNECTED);
                }
                else {
                    this.eventEmitter.emit(IWifi_1.WifiEvent.CLIENT_CONNECT_REJECTED);
                    throw new Error('connection failed');
                }
            }
        });
    }
    disconnect() {
        return __awaiter(this, void 0, void 0, function* () {
            this.networkDetail = null;
            this.eventEmitter.emit(IWifi_1.WifiEvent.CLIENT_DISCONNECTED);
        });
    }
    getConnectedTo() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.networkDetail
                ? {
                    ssid: this.networkDetail.ssid,
                    encrypted: this.networkDetail.encrypted,
                    strength: this.networkDetail.strength,
                }
                : null;
        });
    }
    setCountry(_countryCode) {
        return __awaiter(this, void 0, void 0, function* () {
            this.countryCode = _countryCode;
        });
    }
    getCountry() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.countryCode;
        });
    }
    scan() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!(yield this.isClientEnabled()) && !(yield this.isAPEnabled())) {
                throw new Error('Wifi have to be enabled before scan can begin.');
            }
            return this.getWifiDevices().map(({ ssid, encrypted, strength }) => ({ ssid, encrypted, strength }));
        });
    }
    on(event, listener) {
        this.eventEmitter.on(event, listener);
    }
    once(event, listener) {
        this.eventEmitter.once(event, listener);
    }
    removeListener(event, listener) {
        this.eventEmitter.removeListener(event, listener);
    }
    removeAllListeners(event) {
        this.eventEmitter.removeAllListeners(event);
    }
    getWifiDevices() {
        const GEN_MIN = 100;
        const GEN_MAX = 500;
        let devices = [...wifiDevices];
        if (this.numberOfWifiScans < 1) {
            devices = devices.slice(0, 3);
        }
        else {
            for (let index = devices.length - 2; index < devices.length; index++) {
                devices[index].ssid = devices[index].ssid + (0, IntegerGenerator_1.getIntegerInclusive)(GEN_MIN, GEN_MAX);
            }
        }
        this.numberOfWifiScans++;
        return devices;
    }
}
exports.default = MockWifi;
//# sourceMappingURL=MockWifi.js.map