import IWifi, { IWifiConnectOptions, IWifiDevice, WifiEvent } from '../../NativeDevice/Hardware/IWifi';
export default class MockWifi implements IWifi {
    private networkDetail;
    private wifiState;
    private numberOfWifiScans;
    private countryCode;
    private eventEmitter;
    constructor();
    enableClient(): Promise<void>;
    disable(): Promise<void>;
    enableAP(_ssid: string, _passphrase: string): Promise<void>;
    isClientEnabled(): Promise<boolean>;
    isAPEnabled(): Promise<boolean>;
    connect(_ssid: string, _password?: string, _options?: IWifiConnectOptions): Promise<void>;
    disconnect(): Promise<void>;
    getConnectedTo(): Promise<IWifiDevice | null>;
    setCountry(_countryCode: string): Promise<void>;
    getCountry(): Promise<string | null>;
    scan(): Promise<IWifiDevice[]>;
    on(event: WifiEvent, listener: (...args: any[]) => void): void;
    once(event: WifiEvent, listener: (...args: any[]) => void): void;
    removeListener(event: WifiEvent, listener: (...args: any[]) => void): void;
    removeAllListeners(event?: WifiEvent): void;
    private getWifiDevices;
}
