import { Reducer } from 'redux';
import { ISocketState } from './Socket/socketReducers';
import { IDeviceState } from './Device/deviceReducers';
import { IOrganizationState } from './Organization/organizationReducers';
import { IDeviceAuthenticationState } from './Device/deviceAuthenticationReducers';
import { IDeviceVerificationState } from '../Device/Verification/deviceVerificationReducers';
import { IDeviceRemoteControlState } from './Device/RemoteControl/deviceRemoteControlReducers';
import { INetworkState } from './Network/networkReducers';
import { IKeyboardState } from './Input/keyboardReducers';
import { IAuthenticationState } from '../Authentication/authenticationReducers';
import { IAppletState } from './Applet/appletReducers';
import { IApplicationState } from './Application/applicationReducers';
import { IDebugState } from './Device/Debug/deviceDebugReducers';
import { IBundledAppletState } from './Applet/BundledApplet/bundledAppletReducer';
import { ILicenseState } from './License/licenseReducers';
import { IDeviceConnectState } from './Device/Connect/deviceConnectReducers';
export interface IFrontState {
    applet: IAppletState;
    bundledApplet: IBundledAppletState;
    authentication: IAuthenticationState;
    socket: ISocketState;
    device: IDeviceState;
    debug: IDebugState;
    organization: IOrganizationState;
    deviceAuthentication: IDeviceAuthenticationState;
    deviceVerification: IDeviceVerificationState;
    deviceRemoteControl: IDeviceRemoteControlState;
    network: INetworkState;
    keyboard: IKeyboardState;
    application: IApplicationState;
    license: ILicenseState;
    deviceConnect: IDeviceConnectState;
}
export declare const frontReducer: Reducer<IFrontState>;
