"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
require("./front.sass");
const React = __importStar(require("react"));
const ReactDOM = __importStar(require("react-dom"));
const Main_1 = __importDefault(require("../Front/Web/Display/Main"));
const applicationFactory_1 = require("../Application/applicationFactory");
const frontReducers_1 = require("./frontReducers");
const frontSagas_1 = require("./frontSagas");
const propertyStorage_1 = __importDefault(require("../Property/propertyStorage"));
const Property_1 = __importDefault(require("../Property/Property"));
const deviceDebugHelper_1 = require("./Device/Debug/deviceDebugHelper");
const Responsibilities_1 = require("../Feature/Responsibilities");
const combinedDriver_1 = require("../NativeDevice/Default/combinedDriver");
exports.default = (options) => __awaiter(void 0, void 0, void 0, function* () {
    const { frontDriver, cacheDriver } = (0, combinedDriver_1.normalizeFrontCacheDriver)(options.nativeDriver);
    const propertyStorage = (0, propertyStorage_1.default)(() => cacheDriver);
    try {
        const weinreServerUrl = yield propertyStorage.getValueOrDefault(Property_1.default.DEBUG_WEINRE_SERVER_URL, options.weinreServerUrl);
        options.global.WeinreServerURL = weinreServerUrl;
        options.global.WeinreServerId = yield frontDriver.getDeviceUid();
        const weinreDebugEnabled = yield propertyStorage.getValueOrDefault(Property_1.default.DEBUG_WEINRE_ENABLED, false);
        if (weinreDebugEnabled) {
            (0, deviceDebugHelper_1.startWeinreDebug)(options.global);
        }
    }
    catch (error) {
        console.error(error);
    }
    const subscriptionType = options.subscriptionType;
    const { excludedResponsibilities: _ } = options, newOptions = __rest(options, ["excludedResponsibilities"]);
    const _a = Object.assign({ responsibilities: (0, Responsibilities_1.createAbsentResponsibilities)(...options.excludedResponsibilities) }, newOptions), { baseUrl, platformUri, staticBaseUrl, uploadBaseUrl, checkInterval, weinreServerUrl: weinreUri, extendedManagementUrl } = _a, sagaOptions = __rest(_a, ["baseUrl", "platformUri", "staticBaseUrl", "uploadBaseUrl", "checkInterval", "weinreServerUrl", "extendedManagementUrl"]);
    const config = {
        baseUrl,
        platformUri,
        staticBaseUrl,
        uploadBaseUrl,
        weinreUri,
        extendedManagementUrl,
        subscriptionType,
        checkInterval,
    };
    let lastSagaError;
    const application = yield (0, applicationFactory_1.createApplication)(frontReducers_1.frontReducer, (store) => (0, frontSagas_1.frontSaga)(config, sagaOptions, store.getState, propertyStorage, store.dispatch), () => frontDriver, (e) => {
        lastSagaError = (0, lodash_1.cloneDeep)(e);
        console.warn('Sagas broken', e);
    });
    ReactDOM.render(React.createElement(Main_1.default, { store: application.store }), options.global.document.getElementById('body'));
    options.global.__front = Object.assign(Object.assign({}, options), { store: application.store, storeEmitter: application.storeEmitter, onUnload: application.onUnload, lastSagaError });
});
//# sourceMappingURL=front.js.map