/// <reference types="node" />
import { EventEmitter } from 'events';
import './front.sass';
import { Store } from 'redux';
import { IFrontState } from './frontReducers';
import { IWeinreContainer } from './Device/Debug/deviceDebugHelper';
import ISynchronizer from '../Synchronization/ISynchronizer';
import { IWebWorkerFactory } from '../WebWorker/masterWebWorkerFactory';
import { IFrontManagementDriver } from '../NativeDevice/Management/IManagementDriver';
import { SubscriptionType } from '../Display/IConfig';
import Responsibility from '../Feature/Responsibility';
import { IBundledApplet } from './Applet/BundledApplet/bundledAppletActions';
import { FrontCacheDriver } from '../NativeDevice/Default/combinedDriver';
export type IGlobalContainer = Window & IWeinreContainer & {
    WeinreServerURL?: string;
    WeinreServerId?: string;
    document: Window['document'];
    __front?: IFrontOptions & {
        store: Store<IFrontState>;
        storeEmitter: EventEmitter;
        onUnload: () => void;
        lastSagaError?: Error;
    };
};
export interface IFrontOptions {
    global: IGlobalContainer;
    baseUrl: string;
    platformUri: string;
    staticBaseUrl: string;
    uploadBaseUrl: string;
    checkInterval: number;
    publicKey: string;
    sessionIdKey: string;
    frontAppletPrefix: string;
    frontDisplayVersion: string;
    weinreServerUrl: string;
    /** @deprecated use UpdateExtendedManagementUrl action instead */
    extendedManagementUrl: string | null;
    nativeDriver: FrontCacheDriver;
    managementDriver: IFrontManagementDriver;
    synchronizer: ISynchronizer;
    webWorkerFactory: IWebWorkerFactory;
    applicationVersion: string;
    subscriptionType: SubscriptionType;
    bundledApplet: null | IBundledApplet;
    autoVerification: {
        organizationUid: string;
        deviceName?: string;
    } | undefined;
    excludedResponsibilities: Responsibility[];
    /** Enable cutting url of applet and offline cache files to shorter form so SSSP2 will be able to handle with them */
    shortAppletFilesUrl?: boolean;
}
declare const _default: (options: IFrontOptions) => Promise<void>;
export default _default;
