"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeviceVerification = void 0;
const React = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const MainInfo_1 = __importDefault(require("../../Info/MainInfo"));
const InfoProperty_1 = __importDefault(require("../../Info/InfoProperty"));
const DeviceInfo_1 = __importDefault(require("../../Info/DeviceInfo"));
const HashtagIcon_1 = __importDefault(require("../../Application/Icons/HashtagIcon"));
const OfflineIcon_1 = __importDefault(require("../../Application/Icons/OfflineIcon"));
const DeviceVerification_module_sass_1 = __importDefault(require("./DeviceVerification.module.sass"));
const TimeInfo_1 = __importDefault(require("../../Info/TimeInfo"));
const ConnectingIcon_1 = __importDefault(require("../../Application/Icons/ConnectingIcon"));
const DangerIcon_1 = __importDefault(require("../../Application/Icons/DangerIcon"));
class DeviceVerification extends React.PureComponent {
    render() {
        if (!this.props.verified) {
            const deviceInfo = (React.createElement("div", null,
                React.createElement(TimeInfo_1.default, { timestamp: this.props.timestamp, timezone: this.props.timezone }),
                React.createElement(DeviceInfo_1.default, null,
                    React.createElement(InfoProperty_1.default, { title: 'Device:' }, this.getDeviceModel()),
                    React.createElement(InfoProperty_1.default, { title: 'System:' }, this.getSystemLabel()),
                    React.createElement(InfoProperty_1.default, { title: 'System Version:' }, this.getOsVersion()),
                    React.createElement(InfoProperty_1.default, { title: 'Firmware Version:' }, this.getFirmwareVersion()),
                    React.createElement(InfoProperty_1.default, { title: 'Serial Number:' }, this.getDeviceSerialNumber()),
                    this.props.frontDisplayVersion ? (React.createElement(InfoProperty_1.default, { title: 'Front Display Version:' }, this.props.frontDisplayVersion)) : null,
                    this.props.applicationVersion ? (React.createElement(InfoProperty_1.default, { title: 'Application Version:' }, this.props.applicationVersion)) : null,
                    this.props.network ? React.createElement(InfoProperty_1.default, { title: 'Network:' }, this.props.network) : null,
                    this.props.ipAddress ? React.createElement(InfoProperty_1.default, { title: 'Local IP Address:' }, this.props.ipAddress) : null,
                    React.createElement(InfoProperty_1.default, { title: 'PIN:' }, this.getPinCode()),
                    React.createElement(InfoProperty_1.default, { title: 'Setup menu:' }, "PIN + OK/Enter opens OSD"),
                    React.createElement(InfoProperty_1.default, { title: 'Status:' }, "Device is not verified"))));
            if (!this.props.isOnline) {
                return (React.createElement("div", { key: 'offline', className: DeviceVerification_module_sass_1.default.wrapper },
                    React.createElement(MainInfo_1.default, { title: 'No internet connection', value: '' }),
                    deviceInfo,
                    React.createElement(OfflineIcon_1.default, null)));
            }
            else if (!this.props.isConnected) {
                return (React.createElement("div", { key: 'serverDisconnected', className: DeviceVerification_module_sass_1.default.wrapper },
                    React.createElement(MainInfo_1.default, { title: 'Connecting to the server...', value: '' }),
                    deviceInfo,
                    React.createElement(ConnectingIcon_1.default, null)));
            }
            else if (this.props.verificationHash) {
                return (React.createElement("div", { key: 'verificationHash', className: DeviceVerification_module_sass_1.default.wrapper },
                    React.createElement(MainInfo_1.default, { title: 'Verification Hash:', value: this.props.verificationHash }),
                    deviceInfo,
                    React.createElement(HashtagIcon_1.default, null)));
            }
            else if (this.props.isSerialNumberSupported && !this.props.serialNumber) {
                return (React.createElement("div", { key: 'noSerialNumber', className: DeviceVerification_module_sass_1.default.wrapper },
                    React.createElement(MainInfo_1.default, { title: 'Device registration:', value: 'Unable to register -\n\t\t\t\t\t\tNo serial number' }),
                    deviceInfo,
                    React.createElement(DangerIcon_1.default, null)));
            }
            else {
                return (React.createElement("div", { key: 'inProgress', className: DeviceVerification_module_sass_1.default.wrapper },
                    React.createElement(MainInfo_1.default, { title: 'Device registration:', value: 'in progress' }),
                    deviceInfo,
                    React.createElement(HashtagIcon_1.default, null)));
            }
        }
        else {
            return React.createElement("div", null, this.props.children);
        }
    }
    getSystemLabel() {
        return this.props.applicationType ? this.props.applicationType.toUpperCase() : 'UNKNOWN';
    }
    getDeviceModel() {
        return this.props.model ? this.props.model : 'Unknown';
    }
    getDeviceSerialNumber() {
        return this.props.serialNumber ? this.props.serialNumber : 'Unknown';
    }
    getPinCode() {
        return this.props.pinCode ? this.props.pinCode : '####';
    }
    getOsVersion() {
        return this.props.osVersion ? this.props.osVersion : 'Unknown';
    }
    getFirmwareVersion() {
        return this.props.firmwareVersion ? this.props.firmwareVersion : 'Unknown';
    }
}
exports.DeviceVerification = DeviceVerification;
exports.default = (0, react_redux_1.connect)((state) => {
    return {
        verificationHash: state.deviceVerification.verificationHash,
        verified: state.deviceVerification.verified,
        applicationType: state.device.applicationType,
        model: state.device.model,
        ipAddress: state.device.ipAddress,
        isSerialNumberSupported: state.device.isSerialNumberSupported,
        serialNumber: state.device.serialNumber,
        pinCode: state.device.pinCode,
        network: state.device.activeInterface,
        isOnline: state.network.connected,
        isConnected: state.socket.connected,
        applicationVersion: state.device.applicationVersion,
        timestamp: state.device.timestamp,
        timezone: state.device.timezone,
        firmwareVersion: state.device.firmwareVersion,
        osVersion: state.device.osVersion,
        frontDisplayVersion: state.device.frontDisplayVersion,
    };
}, (_dispatch) => ({}))(DeviceVerification);
//# sourceMappingURL=DeviceVerification.js.map