"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const CornerStatusIndicator_module_sass_1 = __importDefault(require("./CornerStatusIndicator.module.sass"));
class CornerStatusIndicator extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.getPosition = () => {
            const { top, bottom, left, right } = this.props;
            let positionClassName = CornerStatusIndicator_module_sass_1.default.bottomRight;
            if (top && left) {
                positionClassName = CornerStatusIndicator_module_sass_1.default.topLeft;
            }
            else if (top && right) {
                positionClassName = CornerStatusIndicator_module_sass_1.default.topRight;
            }
            else if (bottom && left) {
                positionClassName = CornerStatusIndicator_module_sass_1.default.bottomLeft;
            }
            return positionClassName;
        };
        this.validateProps = () => {
            const ERROR_MSG = 'Invalid combination of props.';
            const ERROR_TOP_BOTTOM = "Can't use top and bottom at the same time.";
            const ERROR_LEFT_RIGHT = "Can't use left and right at the same time.";
            const { top, bottom, left, right } = this.props;
            let errorMessageArr = [ERROR_MSG];
            if (top && bottom) {
                errorMessageArr.push(ERROR_TOP_BOTTOM);
            }
            if (left && right) {
                errorMessageArr.push(ERROR_LEFT_RIGHT);
            }
            if (errorMessageArr.length > 1) {
                throw new Error(errorMessageArr.join(' '));
            }
        };
    }
    render() {
        this.validateProps();
        const { customClass } = this.props;
        const pixelClassName = [CornerStatusIndicator_module_sass_1.default.pixel, this.getPosition(), customClass].join(' ');
        return (React.createElement("div", { className: (0, classnames_1.default)(pixelClassName, 'global-corner-indicator', {
                'global-top': !!this.props.top,
                'global-bottom': !!this.props.bottom,
                'global-left': !!this.props.left,
                'global-right': !!this.props.right,
            }) }));
    }
}
exports.default = CornerStatusIndicator;
//# sourceMappingURL=CornerStatusIndicator.js.map