"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(require("react"));
const ActiveApplet_module_sass_1 = __importDefault(require("./ActiveApplet.module.sass"));
class GaplessApplet extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.currentIframe = null;
        this.nextIframe = null;
    }
    componentDidMount() {
        this.updateIframes();
    }
    componentDidUpdate() {
        this.updateIframes();
    }
    render() {
        return React.createElement("div", { ref: (element) => (this.wrapper = element) });
    }
    updateIframes() {
        if (!this.props.uniqueHash || !this.props.binaryFile) {
            return;
        }
        if (!this.currentIframe) {
            this.createCurrentIframe(this.props.appletUid, this.props.checksum, this.props.uniqueHash, this.props.binaryFile);
        }
        else if (this.currentIframe.checksum === this.props.checksum && this.currentIframe.uniqueHash !== this.props.uniqueHash) {
            this.createCurrentIframe(this.props.appletUid, this.props.checksum, this.props.uniqueHash, this.props.binaryFile);
        }
        else if (this.currentIframe.checksum !== this.props.checksum) {
            if (this.nextIframe && this.props.checksum === this.nextIframe.checksum) {
                this.makeNextIframeCurrent(this.props.appletUid, this.props.uniqueHash);
            }
            else {
                this.createCurrentIframe(this.props.appletUid, this.props.checksum, this.props.uniqueHash, this.props.binaryFile);
            }
        }
        if (this.props.nextAppletUid &&
            this.props.nextChecksum &&
            this.props.nextBinaryFile &&
            this.currentIframe &&
            this.currentIframe.checksum !== this.props.nextChecksum) {
            this.createNextIframe(this.props.nextAppletUid, this.props.nextChecksum, this.props.nextBinaryFile);
        }
    }
    createCurrentIframe(appletUid, checksum, uniqueHash, binaryFile) {
        if (this.currentIframe) {
            const removedId = this.currentIframe.element.id;
            this.wrapper.removeChild(this.currentIframe.element);
            this.props.onRemoved(removedId);
        }
        const iframe = document.createElement('iframe');
        iframe.id = 'applet-' + checksum;
        iframe.src = binaryFile.localUri;
        iframe.setAttribute('scrolling', 'no');
        iframe.setAttribute('allow', 'geolocation *; microphone *; camera *; midi *; encrypted-media *; autoplay *;');
        iframe.setAttribute('class', ActiveApplet_module_sass_1.default.appletIframe);
        this.wrapper.appendChild(iframe);
        this.currentIframe = { checksum, uniqueHash, element: iframe };
        this.props.onCreated(iframe, appletUid);
        this.props.onStart(iframe, appletUid);
        iframe.focus();
    }
    createNextIframe(appletUid, checksum, binaryFile) {
        if (this.nextIframe) {
            const removedId = this.nextIframe.element.id;
            this.wrapper.removeChild(this.nextIframe.element);
            this.props.onRemoved(removedId);
        }
        const iframe = document.createElement('iframe');
        iframe.id = 'applet-' + checksum;
        iframe.src = binaryFile.localUri;
        iframe.style.display = 'none';
        iframe.setAttribute('scrolling', 'no');
        iframe.setAttribute('allow', 'geolocation *; microphone *; camera *; midi *; encrypted-media *; autoplay *;');
        iframe.setAttribute('class', ActiveApplet_module_sass_1.default.appletIframe);
        this.wrapper.appendChild(iframe);
        this.nextIframe = { checksum, element: iframe };
        this.props.onCreated(iframe, appletUid);
    }
    makeNextIframeCurrent(appletUid, uniqueHash) {
        if (this.nextIframe) {
            const iframe = this.nextIframe.element;
            iframe.style.display = 'block';
            if (this.currentIframe) {
                const removedId = this.currentIframe.element.id;
                this.wrapper.removeChild(this.currentIframe.element);
                this.props.onRemoved(removedId);
            }
            this.currentIframe = {
                checksum: this.nextIframe.checksum,
                uniqueHash,
                element: iframe,
            };
            this.nextIframe = null;
            this.props.onStart(iframe, appletUid);
            iframe.focus();
        }
    }
}
exports.default = GaplessApplet;
//# sourceMappingURL=GaplessApplet.js.map