import * as React from 'react';
import { IFile as IFileSystemFile } from '../../../NativeDevice/fileSystem';
import 'typeface-muli';
export interface IStateProps {
    appletUid: string;
    appletBinaryFile: IFileSystemFile;
    appletMissing: boolean;
    appletUniqueHash: string;
    appletChecksum: string;
    nextAppletUid?: string;
    nextAppletBinaryFile?: IFileSystemFile;
    nextAppletChecksum?: string;
    deviceName: string;
    model: string | null;
    organizationTitle: string;
    appletIsMuted: boolean;
    applicationType: string | null;
    ethernetMacAddress: string | null;
    wifiMacAddress: string | null;
    serialNumber: string | null;
    frontDisplayVersion: string;
    applicationVersion: string;
    timezone: string;
    timestamp: number;
    ipAddress: string;
    interfaceName: string;
    osVersion: string;
    firmwareVersion: string;
}
export interface IDispatchProps {
    onAppletIframeCreated(appletUid: string, appletIframeId: string): void;
    onAppletIframeStarted(appletUid: string, appletIframeId: string): void;
    onAppletIframeRemoved(appletIframeId: string): void;
}
export declare class ActiveApplet extends React.PureComponent<IStateProps & IDispatchProps> {
    render(): JSX.Element | null;
    private getSystemLabel;
    private getDeviceModel;
}
declare const _default: import("react-redux").ComponentClass<unknown>;
export default _default;
