"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.touchSaga = void 0;
const effects_1 = require("redux-saga/effects");
const sendAppletMessage_1 = require("../Applet/sendAppletMessage");
const motionActions_1 = require("@signageos/actions/dist/Input/motionActions");
const channels_1 = require("../../ReduxSaga/channels");
const GestureAction_1 = __importDefault(require("../../NativeDevice/Input/GestureAction"));
const touchGestureResolver_1 = require("./touchGestureResolver");
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/front-display:Front:Touch:touchSaga');
function* touchSaga(messageTypePrefix, getState, getNativeDriver, window) {
    const touchEventChannel = createTouchEventChannel(window);
    yield (0, channels_1.takeEvery)(touchEventChannel, function* (event) {
        try {
            for (let gesture of (0, touchGestureResolver_1.handleTouch)(event.type)) {
                yield (0, effects_1.put)({
                    type: motionActions_1.HandleMotion,
                    gestureAction: GestureAction_1.default[gesture],
                });
            }
        }
        catch (error) {
            debug('event ignored', event);
        }
    });
    getNativeDriver().forwardTouchEvents((data) => {
        debug('Touch event received: ', data.x, data.y);
        (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, Object.assign(Object.assign({}, data), { type: messageTypePrefix + '.touch.propagate' }));
    });
}
exports.touchSaga = touchSaga;
function createTouchEventChannel(window) {
    const messageChannel = (0, channels_1.createChannel)();
    window.addEventListener('touchstart', (event) => messageChannel.put(event));
    window.addEventListener('touchend', (event) => messageChannel.put(event));
    window.addEventListener('touchcancel', (event) => messageChannel.put(event));
    window.addEventListener('touchmove', (event) => messageChannel.put(event));
    return messageChannel;
}
//# sourceMappingURL=touchSaga.js.map