"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.resetLastTap = exports.handleTouch = void 0;
const GestureAction_1 = __importDefault(require("../../NativeDevice/Input/GestureAction"));
// in the future this can contain complex logic to resolve all kinds of touch gestures
const DOUBLE_TAP_THRESHOLD = 500;
let lastTap = null;
function handleTouch(type) {
    if (type === 'touchend') {
        const result = [GestureAction_1.default.SINGLE_TAP_UP];
        const now = new Date().valueOf();
        if (lastTap != null && now - lastTap <= DOUBLE_TAP_THRESHOLD) {
            result.push(GestureAction_1.default.DOUBLE_TAP);
        }
        lastTap = now;
        return result;
    }
    return [];
}
exports.handleTouch = handleTouch;
// for tests
function resetLastTap() {
    lastTap = null;
}
exports.resetLastTap = resetLastTap;
//# sourceMappingURL=touchGestureResolver.js.map