"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const FrontCapability_1 = __importDefault(require("../../NativeDevice/Front/FrontCapability"));
const t = __importStar(require("./../../Test/TestFramework"));
const deviceTestActions_1 = require("@signageos/actions/dist/Device/Test/deviceTestActions");
const TEST_DIRECTORY_PATH = 'test';
const host = 'https://2.signageos.io/assets';
const VIDEO1_URI = `${host}/test-videos-03_AME/video-test-03_15s_1920x1080_2fe7b039750a134aeac1c0a515710007.mp4`;
const VIDEO2_URI = `${host}/test-videos-04_AME/video-test-04_15s_1920x1080_88f90af5fa281d7efb8eae17848e71d9.mp4`;
const VIDEO_4K_URI = `${host}/test-videos-02_AME/video-test-02_15s_3840x2160_09c01fa898c80160edde2a1218ac6043.mp4`;
const VIDEO_SMALL_URI = `${host}/test-videos-03_AME/video-test-03_15s_320x200_5ce761cc9739c9a2d4c55be9ca7a8763.mp4`;
const VIDEO1_FILENAME = 'video1.mp4';
const VIDEO2_FILENAME = 'video2.mp4';
const VIDEO_4K_FILENAME = 'video_4k.mp4';
const VIDEO_SMALL_FILENAME = 'video_small.mp4';
let nativeDriver;
exports.default = (loadNativeDriver) => __awaiter(void 0, void 0, void 0, function* () {
    nativeDriver = loadNativeDriver;
    return t.describe(deviceTestActions_1.TestCase.VIDEO, function* () {
        yield t.before('download video files', () => __awaiter(this, void 0, void 0, function* () {
            const internalStorageUnit = yield getInternalStorageUnit();
            const testDirectoryFilePath = { storageUnit: internalStorageUnit, filePath: TEST_DIRECTORY_PATH };
            if (yield nativeDriver.fileSystem.exists(testDirectoryFilePath)) {
                yield nativeDriver.fileSystem.deleteFile(testDirectoryFilePath, true);
            }
            yield nativeDriver.fileSystem.createDirectory(testDirectoryFilePath);
            yield Promise.all([
                downloadVideoFile(VIDEO1_FILENAME, VIDEO1_URI),
                downloadVideoFile(VIDEO2_FILENAME, VIDEO2_URI),
                downloadVideoFile(VIDEO_4K_FILENAME, VIDEO_4K_URI),
                downloadVideoFile(VIDEO_SMALL_FILENAME, VIDEO_SMALL_URI),
            ]);
        }));
        yield t.after('delete test files', () => __awaiter(this, void 0, void 0, function* () {
            const internalStorageUnit = yield getInternalStorageUnit();
            const testDirectoryFilePath = { storageUnit: internalStorageUnit, filePath: TEST_DIRECTORY_PATH };
            yield nativeDriver.fileSystem.deleteFile(testDirectoryFilePath, true);
        }));
        yield t.afterEach('clear nativeDriver.video', () => __awaiter(this, void 0, void 0, function* () {
            yield nativeDriver.video.clearAll();
        }));
        // ? beforeEach (await nativeDriver.video.clearAll();)?
        yield t.it('testPrepareVideo', () => __awaiter(this, void 0, void 0, function* () {
            yield nativeDriver.video.clearAll();
            const videoFile = yield getVideoFile(VIDEO1_FILENAME);
            yield nativeDriver.video.prepare(videoFile.localUri, 0, 0, 1920, 1080);
        }));
        yield t.it('testPrepareMultipleVideos', () => __awaiter(this, void 0, void 0, function* () {
            const videoMaxCount = nativeDriver.video.getMaxVideoCount();
            if (videoMaxCount === 1) {
                t.skip('Only 1 video is supported');
                return;
            }
            if (videoMaxCount === null) {
                t.skip('The max allowed videos is not specified');
                return;
            }
            yield nativeDriver.video.clearAll();
            const videoFile = yield getVideoFile(VIDEO_SMALL_FILENAME);
            for (let i = 0; i < videoMaxCount; i++) {
                yield nativeDriver.video.prepare(videoFile.localUri, i * 100, 0, 100, 100);
            }
        }));
        yield t.it('testPrepareVideoFailsWhenAllVideosArePlaying', () => __awaiter(this, void 0, void 0, function* () {
            const videoMaxCount = nativeDriver.video.getMaxVideoCount();
            if (videoMaxCount === null) {
                t.skip('Max video count is not defined');
                return;
            }
            yield nativeDriver.video.clearAll();
            const videoFile = yield getVideoFile(VIDEO_SMALL_FILENAME);
            for (let i = 0; i < videoMaxCount; i++) {
                yield nativeDriver.video.play(videoFile.localUri, i * 100, 0, 100, 100);
            }
            yield nativeDriver.video.prepare(videoFile.localUri, videoMaxCount * 100, 0, 100, 100).then(() => {
                t.skip("prepare didn't fail");
            }, (_expected) => {
                // OK
            });
        }));
        yield t.it('testPlayVideo', () => __awaiter(this, void 0, void 0, function* () {
            yield nativeDriver.video.clearAll();
            const videoFile = yield getVideoFile(VIDEO1_FILENAME);
            const videoEventEmitter = yield nativeDriver.video.play(videoFile.localUri, 0, 0, 1920, 1080);
            yield new Promise((resolve, reject) => {
                videoEventEmitter.on('ended', resolve);
                videoEventEmitter.on('error', () => reject(new Error('test video play failed')));
            });
        }));
        yield t.it('testPrepareAndPlayVideo', () => __awaiter(this, void 0, void 0, function* () {
            yield nativeDriver.video.clearAll();
            const videoFile = yield getVideoFile(VIDEO1_FILENAME);
            yield nativeDriver.video.prepare(videoFile.localUri, 0, 0, 1920, 1080);
            const videoEventEmitter = yield nativeDriver.video.play(videoFile.localUri, 0, 0, 1920, 1080);
            yield new Promise((resolve, reject) => {
                videoEventEmitter.on('ended', resolve);
                videoEventEmitter.on('error', () => reject(new Error('test video play failed')));
            });
        }));
        yield t.it('testPlay2Videos', () => __awaiter(this, void 0, void 0, function* () {
            const videoMaxCount = nativeDriver.video.getMaxVideoCount();
            if (videoMaxCount === 1) {
                t.skip('Only 1 video is supported');
                return;
            }
            yield nativeDriver.video.clearAll();
            const video1File = yield getVideoFile(VIDEO_SMALL_FILENAME);
            const video2File = yield getVideoFile(VIDEO_SMALL_FILENAME);
            const video1EventEmitter = yield nativeDriver.video.play(video1File.localUri, 200, 200, 430, 270);
            const video2EventEmitter = yield nativeDriver.video.play(video2File.localUri, 650, 400, 430, 270);
            yield Promise.all([
                new Promise((resolve, reject) => {
                    video1EventEmitter.on('ended', resolve);
                    video1EventEmitter.on('error', () => reject(new Error('test video play failed')));
                }),
                new Promise((resolve, reject) => {
                    video2EventEmitter.on('ended', resolve);
                    video2EventEmitter.on('error', () => reject(new Error('test video play failed')));
                }),
            ]);
        }));
        yield t.it('testPlayTooManyPostponedPlay', () => __awaiter(this, void 0, void 0, function* () {
            const videoMaxCount = nativeDriver.video.getMaxVideoCount();
            if (videoMaxCount === null) {
                t.skip('Max video count is not defined.');
                return;
            }
            yield nativeDriver.video.clearAll();
            const videoFile = yield getVideoFile(VIDEO_SMALL_FILENAME);
            for (let i = 0; i < videoMaxCount; i++) {
                yield nativeDriver.video.play(videoFile.localUri, i * 100, 0, 100, 100);
            }
            const extraPlayPromise = nativeDriver.video.play(videoFile.localUri, videoMaxCount * 100, 0, 100, 100);
            yield nativeDriver.video.stop(videoFile.localUri, 0, 0, 100, 100);
            yield extraPlayPromise;
        }));
        yield t.it('testPlay4KVideo', () => __awaiter(this, void 0, void 0, function* () {
            if (!(yield nativeDriver.frontSupports(FrontCapability_1.default.VIDEO_4K))) {
                t.skip('4K video not supported');
                return;
            }
            yield nativeDriver.video.clearAll();
            const videoFile = yield getVideoFile(VIDEO_4K_FILENAME);
            yield nativeDriver.video.prepare(videoFile.localUri, 0, 0, 1920, 1080, { '4k': true });
            const videoEventEmitter = yield nativeDriver.video.play(videoFile.localUri, 0, 0, 1920, 1080);
            yield new Promise((resolve, reject) => {
                videoEventEmitter.on('ended', resolve);
                videoEventEmitter.on('error', () => reject(new Error('test video play failed')));
            });
        }));
        yield t.it('testPlay4KFailIfNotSupported', () => __awaiter(this, void 0, void 0, function* () {
            if (yield nativeDriver.frontSupports(FrontCapability_1.default.VIDEO_4K)) {
                t.skip('4K video is supported');
                return;
            }
            yield nativeDriver.video.clearAll();
            const videoFile = yield getVideoFile(VIDEO_4K_FILENAME);
            yield nativeDriver.video.prepare(videoFile.localUri, 0, 0, 1920, 1080, { '4k': true }).then(() => {
                t.skip("prepare didn't fail");
            }, (_expected) => {
                // OK
            });
        }));
    });
});
function getInternalStorageUnit() {
    return __awaiter(this, void 0, void 0, function* () {
        const storageUnits = yield nativeDriver.fileSystem.listStorageUnits();
        const storageUnit = storageUnits.find((su) => !su.removable);
        return storageUnit;
    });
}
function downloadVideoFile(filename, uri) {
    return __awaiter(this, void 0, void 0, function* () {
        const internalStorageUnit = yield getInternalStorageUnit();
        const downloadPath = `${TEST_DIRECTORY_PATH}/${filename}`;
        const downloadFilePath = { storageUnit: internalStorageUnit, filePath: downloadPath };
        yield nativeDriver.fileSystem.downloadFile(downloadFilePath, uri);
        const videoFile = yield nativeDriver.fileSystem.getFile(downloadFilePath);
        if (!videoFile) {
            throw new Error('Failed to download video file');
        }
    });
}
function getVideoFile(filename) {
    return __awaiter(this, void 0, void 0, function* () {
        const internalStorageUnit = yield getInternalStorageUnit();
        const filePathString = `${TEST_DIRECTORY_PATH}/${filename}`;
        const filePath = { storageUnit: internalStorageUnit, filePath: filePathString };
        const videoFile = yield nativeDriver.fileSystem.getFile(filePath);
        if (!videoFile) {
            throw new Error('Failed to download video file');
        }
        return videoFile;
    });
}
//# sourceMappingURL=VideoTest.js.map