"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const should_1 = __importDefault(require("../../Test/should"));
const HashAlgorithm_1 = __importDefault(require("../../NativeDevice/HashAlgorithm"));
const FrontCapability_1 = __importDefault(require("../../NativeDevice/Front/FrontCapability"));
const t = __importStar(require("./../../Test/TestFramework"));
const deviceTestActions_1 = require("@signageos/actions/dist/Device/Test/deviceTestActions");
const basicErrors_1 = require("../../NativeDevice/Error/basicErrors");
const TEST_DIRECTORY_PATH = 'test';
const UPLOAD_URI = 'https://upload.signageos.io/upload/file?prefix=feature-tests/';
const IMAGE_URI = 'https://signageostest.blob.core.windows.net/front-display/signageos-logo_f87b2be019aa1cf704680b8984aaa5b9.png';
const TEXT_URI = 'https://signageostest.blob.core.windows.net/front-display/my-file1_c31399fd1affe0acef380c5820821af4.txt';
const TEXT2_URI = 'https://signageostest.blob.core.windows.net/front-display/my-file2_c35be2b65e97e065a4b4700106933ea7.txt';
const ARCHIVE_URI = 'https://signageostest.blob.core.windows.net/front-display/test_542d76e5d64d81483dfa9b1ef9c4a4f8.zip';
const BLUE_BACK_IMAGE_URI = 'https://2.signageos.io/assets/cars/back-black.jpg';
const CAR_ORANGE_IMAGE_URI = 'https://2.signageos.io/assets/cars/semifront-orange.jpg';
const CAR_BLACK_IMAGE_URI = 'https://2.signageos.io/assets/cars/semiside-black.jpg';
const CAR_BLUE_IMAGE_URI = 'https://2.signageos.io/assets/cars/semifront-blue.jpg';
exports.default = (nativeDriver) => __awaiter(void 0, void 0, void 0, function* () {
    const fileSystem = nativeDriver.fileSystem;
    const internalStorageUnit = (yield nativeDriver.frontSupports(FrontCapability_1.default.FILE_SYSTEM_INTERNAL_STORAGE))
        ? yield getInternalStorageUnit(fileSystem)
        : undefined;
    const externalStorageUnit = (yield nativeDriver.frontSupports(FrontCapability_1.default.FILE_SYSTEM_EXTERNAL_STORAGE))
        ? yield getFirstExternalStorageUnit(fileSystem)
        : undefined;
    const supportsFileChecksum = () => __awaiter(void 0, void 0, void 0, function* () { return yield nativeDriver.frontSupports(FrontCapability_1.default.FILE_SYSTEM_FILE_CHECKSUM); });
    const supportsLink = () => __awaiter(void 0, void 0, void 0, function* () { return yield nativeDriver.frontSupports(FrontCapability_1.default.FILE_SYSTEM_LINK); });
    const supportsArchiveInfo = () => __awaiter(void 0, void 0, void 0, function* () { return yield nativeDriver.frontSupports(FrontCapability_1.default.FILE_SYSTEM_ARCHIVE_EXTRACT_INFO); });
    return t.describe(deviceTestActions_1.TestCase.FILE_SYSTEM, function* () {
        yield t.before('Has internal *or* external storage unit?', () => __awaiter(this, void 0, void 0, function* () {
            if (!internalStorageUnit && !externalStorageUnit) {
                t.skip('No.');
            }
        }));
        yield t.describe('testing with internalStorageUnit', function* () {
            yield t.before('Has internal storage unit?', () => __awaiter(this, void 0, void 0, function* () {
                if (!internalStorageUnit) {
                    t.skip('No.');
                }
            }));
            const internalTestDirectory = {
                storageUnit: internalStorageUnit,
                filePath: TEST_DIRECTORY_PATH,
            };
            yield* manageTestDirectories(fileSystem, internalTestDirectory);
            yield t.it('should test GetFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetFile(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test GetFileNotExistsFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetFileNotExistsFail(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test WriteFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testWriteFile(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test WriteFileAlreadyExistsOverrides', () => __awaiter(this, void 0, void 0, function* () {
                yield testWriteFileAlreadyExistsOverrides(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test AppendFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testAppendFile(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test AppendFileAlreadyExistsAppends', () => __awaiter(this, void 0, void 0, function* () {
                yield testAppendFileAlreadyExistsAppends(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test IsDirectory', () => __awaiter(this, void 0, void 0, function* () {
                yield testIsDirectory(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test IsDirectoryIfNotExistingFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testIsDirectoryIfNotExistingFail(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test DeleteFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testDeleteFile(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test DeleteDirectory', () => __awaiter(this, void 0, void 0, function* () {
                yield testDeleteDirectory(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test DeleteDirectoryRecursively', () => __awaiter(this, void 0, void 0, function* () {
                yield testDeleteDirectoryRecursively(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test DeleteDirectoryNotRecursivelyFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testDeleteDirectoryNotRecursivelyFail(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test DeleteFileNotExistingFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testDeleteFileNotExistingFail(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test CreateDirectory', () => __awaiter(this, void 0, void 0, function* () {
                yield testCreateDirectory(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test CreateDirectoryFailIfAlreadyExists', () => __awaiter(this, void 0, void 0, function* () {
                yield testCreateDirectoryFailIfAlreadyExists(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test CreateDirectoryFailIfCreatingNested', () => __awaiter(this, void 0, void 0, function* () {
                yield testCreateDirectoryFailIfCreatingNested(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test DownloadFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testDownloadFile(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test DownloadTextFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testDownloadTextFile(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test DownloadOverridesOriginalFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testDownloadOverridesOriginalFile(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test DownloadToNotExistingContainingDirectoryFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testDownloadToNotExistingContainingDirectoryFail(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test DownloadToExistingDirectoryPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testDownloadToExistingDirectoryPathFail(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test UploadFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testUploadFile(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test ListFiles', () => __awaiter(this, void 0, void 0, function* () {
                yield testListFiles(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test ListFilesOfNotExistingDirectoryFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testListFilesOfNotExistingDirectoryFail(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test ListFilesOfFileFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testListFilesOfFileFail(fileSystem, internalTestDirectory);
            }));
            yield t.it('should test CopyFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFile(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test CopyDirectory', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyDirectory(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test CopyFileToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileOverwriteExistingPath(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test CopyDirectoryToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyDirectoryOverwriteExistingPath(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test CopyFileToAlreadyExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileToAlreadyExistingPathFail(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test CopyFileToNotExistingContainingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileToNotExistingContainingPathFail(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test CopyFileFromNotExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileFromNotExistingPathFail(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test MoveFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFile(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test MoveDirectory', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveDirectory(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test MoveFileToAlreadyExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileToAlreadyExistingPathFail(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test MoveFileToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileOverwrite(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test MoveDirectoryToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveDirectoryOverwrite(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test MoveFileToNotExistingContainingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileToNotExistingContainingPathFail(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test MoveFileFromNotExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileFromNotExistingPathFail(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test LinkFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testLinkFile(fileSystem, internalTestDirectory, internalTestDirectory, supportsLink);
            }));
            yield t.it('should test testLinkFileToExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testLinkFileToExistingPathFail(fileSystem, internalTestDirectory, internalTestDirectory, supportsLink);
            }));
            yield t.it('should test GetFileChecksum', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetFileChecksum(fileSystem, internalTestDirectory, supportsFileChecksum);
            }));
            yield t.it('should test GetFileChecksum on problematic files', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetFileChecksumOnPictures(fileSystem, internalTestDirectory, supportsFileChecksum);
            }));
            yield t.it('should test GetFileChecksumOfNotExistingFileFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetFileChecksumOfNotExistingFileFail(fileSystem, internalTestDirectory, supportsFileChecksum);
            }));
            yield t.it('should test GetFileChecksumOfDirectoryFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetFileChecksumOfDirectoryFail(fileSystem, internalTestDirectory, supportsFileChecksum);
            }));
            yield t.it('should test ExtractFileZip', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZip(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test ExtractFileZipOverridesExisting', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZipOverridesExisting(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test ExtractFileZipIfArchiveNotExistsFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZipIfArchiveNotExistsFail(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test ExtractFileZipIfTargetNotExists', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZipIfTargetNotExists(fileSystem, internalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test GetArchiveSize', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetArchiveSize(fileSystem, internalTestDirectory, supportsArchiveInfo);
            }));
            yield t.it('should test GetArchiveSizeIfArchiveNotExistsFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetArchiveSizeIfArchiveNotExistsFail(fileSystem, internalTestDirectory, supportsArchiveInfo);
            }));
        });
        yield t.describe('testing with externalStorageUnit', function* () {
            yield t.before('Has external storage unit?', () => __awaiter(this, void 0, void 0, function* () {
                if (!externalStorageUnit) {
                    t.skip('No.');
                }
            }));
            const externalTestDirectory = {
                storageUnit: externalStorageUnit,
                filePath: TEST_DIRECTORY_PATH,
            };
            yield* manageTestDirectories(fileSystem, externalTestDirectory);
            yield t.it('should test GetFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetFile(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test GetFileNotExistsFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetFileNotExistsFail(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test WriteFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testWriteFile(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test WriteFileAlreadyExistsOverrides', () => __awaiter(this, void 0, void 0, function* () {
                yield testWriteFileAlreadyExistsOverrides(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test AppendFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testAppendFile(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test AppendFileAlreadyExistsAppends', () => __awaiter(this, void 0, void 0, function* () {
                yield testAppendFileAlreadyExistsAppends(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test IsDirectory', () => __awaiter(this, void 0, void 0, function* () {
                yield testIsDirectory(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test IsDirectoryIfNotExistingFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testIsDirectoryIfNotExistingFail(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test DeleteFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testDeleteFile(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test DeleteDirectory', () => __awaiter(this, void 0, void 0, function* () {
                yield testDeleteDirectory(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test DeleteDirectoryRecursively', () => __awaiter(this, void 0, void 0, function* () {
                yield testDeleteDirectoryRecursively(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test DeleteDirectoryNotRecursivelyFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testDeleteDirectoryNotRecursivelyFail(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test DeleteFileNotExistingFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testDeleteFileNotExistingFail(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test CreateDirectory', () => __awaiter(this, void 0, void 0, function* () {
                yield testCreateDirectory(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test CreateDirectoryFailIfAlreadyExists', () => __awaiter(this, void 0, void 0, function* () {
                yield testCreateDirectoryFailIfAlreadyExists(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test CreateDirectoryFailIfCreatingNested', () => __awaiter(this, void 0, void 0, function* () {
                yield testCreateDirectoryFailIfCreatingNested(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test DownloadFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testDownloadFile(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test DownloadTextFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testDownloadTextFile(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test DownloadOverridesOriginalFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testDownloadOverridesOriginalFile(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test DownloadToNotExistingContainingDirectoryFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testDownloadToNotExistingContainingDirectoryFail(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test DownloadToExistingDirectoryPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testDownloadToExistingDirectoryPathFail(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test UploadFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testUploadFile(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test ListFiles', () => __awaiter(this, void 0, void 0, function* () {
                yield testListFiles(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test ListFilesOfNotExistingDirectoryFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testListFilesOfNotExistingDirectoryFail(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test ListFilesOfFileFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testListFilesOfFileFail(fileSystem, externalTestDirectory);
            }));
            yield t.it('should test GetFileChecksum', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetFileChecksum(fileSystem, externalTestDirectory, supportsFileChecksum);
            }));
            yield t.it('should test GetFileChecksum on problematic files', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetFileChecksumOnPictures(fileSystem, externalTestDirectory, supportsFileChecksum);
            }));
            yield t.it('should test GetFileChecksumOfNotExistingFileFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetFileChecksumOfNotExistingFileFail(fileSystem, externalTestDirectory, supportsFileChecksum);
            }));
            yield t.it('should test GetFileChecksumOfDirectoryFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetFileChecksumOfDirectoryFail(fileSystem, externalTestDirectory, supportsFileChecksum);
            }));
            yield t.it('should test CopyFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFile(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test CopyDirectory', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyDirectory(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test CopyFileToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileOverwriteExistingPath(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test CopyDirectoryToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyDirectoryOverwriteExistingPath(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test CopyFileToAlreadyExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileToAlreadyExistingPathFail(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test CopyFileToNotExistingContainingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileToNotExistingContainingPathFail(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test CopyFileFromNotExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileFromNotExistingPathFail(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test MoveFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFile(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test MoveDirectory', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveDirectory(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test MoveFileToAlreadyExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileToAlreadyExistingPathFail(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test MoveFileToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileOverwrite(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test MoveDirectoryToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveDirectoryOverwrite(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test MoveFileToNotExistingContainingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileToNotExistingContainingPathFail(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test MoveFileFromNotExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileFromNotExistingPathFail(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test ExtractFileZip', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZip(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test ExtractFileZipOverridesExisting', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZipOverridesExisting(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test ExtractFileZipIfArchiveNotExistsFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZipIfArchiveNotExistsFail(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test ExtractFileZipIfTargetNotExists', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZipIfTargetNotExists(fileSystem, externalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test GetArchiveSize', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetArchiveSize(fileSystem, externalTestDirectory, supportsArchiveInfo);
            }));
            yield t.it('should test GetArchiveSizeIfArchiveNotExistsFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testGetArchiveSizeIfArchiveNotExistsFail(fileSystem, externalTestDirectory, supportsArchiveInfo);
            }));
        });
        yield t.describe('testing from externalStorageUnit to internalStorageUnit', function* () {
            yield t.before('Has internal *and* external storage units?', () => __awaiter(this, void 0, void 0, function* () {
                if (!internalStorageUnit || !externalStorageUnit) {
                    t.skip('No.');
                }
            }));
            const internalTestDirectory = {
                storageUnit: internalStorageUnit,
                filePath: TEST_DIRECTORY_PATH,
            };
            const externalTestDirectory = {
                storageUnit: externalStorageUnit,
                filePath: TEST_DIRECTORY_PATH,
            };
            yield* manageTestDirectories(fileSystem, internalTestDirectory, externalTestDirectory);
            yield t.it('should test CopyFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFile(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test CopyDirectory', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyDirectory(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test CopyFileToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileOverwriteExistingPath(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test CopyDirectoryToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyDirectoryOverwriteExistingPath(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test CopyFileToAlreadyExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileToAlreadyExistingPathFail(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test CopyFileToNotExistingContainingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileToNotExistingContainingPathFail(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test CopyFileFromNotExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileFromNotExistingPathFail(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test MoveFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFile(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test MoveDirectory', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveDirectory(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test MoveFileToAlreadyExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileToAlreadyExistingPathFail(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test MoveFileToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileOverwrite(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test MoveDirectoryToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveDirectoryOverwrite(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test MoveFileToNotExistingContainingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileToNotExistingContainingPathFail(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test MoveFileFromNotExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileFromNotExistingPathFail(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test ExtractFileZip', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZip(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test ExtractFileZipOverridesExisting', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZipOverridesExisting(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test ExtractFileZipIfArchiveNotExistsFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZipIfArchiveNotExistsFail(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
            yield t.it('should test ExtractFileZipIfTargetNotExists', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZipIfTargetNotExists(fileSystem, externalTestDirectory, internalTestDirectory);
            }));
        });
        yield t.describe('testing from internalStorageUnit to externalStorageUnit', function* () {
            yield t.before('Has internal *and* external storage units?', () => __awaiter(this, void 0, void 0, function* () {
                if (!internalStorageUnit || !externalStorageUnit) {
                    t.skip('No.');
                }
            }));
            const internalTestDirectory = {
                storageUnit: internalStorageUnit,
                filePath: TEST_DIRECTORY_PATH,
            };
            const externalTestDirectory = {
                storageUnit: externalStorageUnit,
                filePath: TEST_DIRECTORY_PATH,
            };
            yield* manageTestDirectories(fileSystem, internalTestDirectory, externalTestDirectory);
            yield t.it('should test CopyFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFile(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test CopyDirectory', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyDirectory(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test CopyFileToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileOverwriteExistingPath(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test CopyDirectoryToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyDirectoryOverwriteExistingPath(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test CopyFileToAlreadyExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileToAlreadyExistingPathFail(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test CopyFileToNotExistingContainingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileToNotExistingContainingPathFail(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test CopyFileFromNotExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testCopyFileFromNotExistingPathFail(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test MoveFile', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFile(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test MoveDirectory', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveDirectory(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test MoveFileToAlreadyExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileToAlreadyExistingPathFail(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test MoveFileToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileOverwrite(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test MoveDirectoryToAlreadyExistingPathOverwrite', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveDirectoryOverwrite(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test MoveFileToNotExistingContainingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileToNotExistingContainingPathFail(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test MoveFileFromNotExistingPathFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testMoveFileFromNotExistingPathFail(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test ExtractFileZip', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZip(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test ExtractFileZipOverridesExisting', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZipOverridesExisting(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test ExtractFileZipIfArchiveNotExistsFail', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZipIfArchiveNotExistsFail(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
            yield t.it('should test ExtractFileZipIfTargetNotExists', () => __awaiter(this, void 0, void 0, function* () {
                yield testExtractFileZipIfTargetNotExists(fileSystem, internalTestDirectory, externalTestDirectory);
            }));
        });
    });
});
function testGetFile(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const downloadFilePath = resolve(testDirectory, 'download.png');
        yield fileSystem.downloadFile(downloadFilePath, IMAGE_URI);
        const file = yield fileSystem.getFile(downloadFilePath);
        (0, should_1.default)(file.localUri).ok();
    });
}
function testGetFileNotExistsFail(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const downloadFilePath = resolve(testDirectory, 'download.png');
        const file = yield fileSystem.getFile(downloadFilePath);
        (0, should_1.default)(file).null();
    });
}
function testWriteFile(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const writeFilePath = resolve(testDirectory, 'written.png');
        yield fileSystem.writeFile(writeFilePath, `Some text content to write`);
        const file = yield fileSystem.getFile(writeFilePath);
        (0, should_1.default)(file.localUri).ok();
        const textResponse = yield fetch(file.localUri);
        const textContent = yield textResponse.text();
        (0, should_1.default)(textContent).equal(`Some text content to write`);
    });
}
function testWriteFileAlreadyExistsOverrides(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const writeFilePath = resolve(testDirectory, 'written.png');
        yield fileSystem.writeFile(writeFilePath, `Some text content to write`);
        const file1 = yield fileSystem.getFile(writeFilePath);
        const textResponse1 = yield fetch(file1.localUri);
        const textContent1 = yield textResponse1.text();
        (0, should_1.default)(textContent1).equal(`Some text content to write`);
        yield fileSystem.writeFile(writeFilePath, `Rewrite with other contents`);
        const file2 = yield fileSystem.getFile(writeFilePath);
        const textResponse2 = yield fetch(file2.localUri);
        const textContent2 = yield textResponse2.text();
        (0, should_1.default)(textContent2).equal(`Rewrite with other contents`);
    });
}
function testAppendFile(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const appendFilePath = resolve(testDirectory, 'written.png');
        yield fileSystem.appendFile(appendFilePath, `Some text content to write`);
        const file = yield fileSystem.getFile(appendFilePath);
        (0, should_1.default)(file.localUri).ok();
        const textResponse = yield fetch(file.localUri);
        const textContent = yield textResponse.text();
        (0, should_1.default)(textContent).equal(`Some text content to write`);
    });
}
function testAppendFileAlreadyExistsAppends(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const appendFilePath = resolve(testDirectory, 'written.png');
        yield fileSystem.appendFile(appendFilePath, `Some text content to write`);
        const file1 = yield fileSystem.getFile(appendFilePath);
        const textResponse1 = yield fetch(file1.localUri);
        const textContent1 = yield textResponse1.text();
        (0, should_1.default)(textContent1).equal(`Some text content to write`);
        yield fileSystem.appendFile(appendFilePath, `\nAppend with other contents`);
        const file2 = yield fileSystem.getFile(appendFilePath);
        const textResponse2 = yield fetch(file2.localUri);
        const textContent2 = yield textResponse2.text();
        (0, should_1.default)(textContent2).equal(`Some text content to write\nAppend with other contents`);
    });
}
function testIsDirectory(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const downloadFilePath = resolve(testDirectory, 'download.png');
        yield fileSystem.downloadFile(downloadFilePath, IMAGE_URI);
        (0, should_1.default)(yield fileSystem.isDirectory(testDirectory)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(downloadFilePath)).false();
    });
}
function testIsDirectoryIfNotExistingFail(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const testSubDirectoryFilePath = resolve(testDirectory, 'sub-dir');
        (0, should_1.default)(yield fileSystem.exists(testSubDirectoryFilePath)).false();
        yield (0, should_1.default)(fileSystem.isDirectory(testSubDirectoryFilePath)).rejected();
    });
}
function testDeleteFile(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const downloadFilePath = resolve(testDirectory, 'download.png');
        yield fileSystem.downloadFile(downloadFilePath, IMAGE_URI);
        (0, should_1.default)(yield fileSystem.exists(downloadFilePath)).true();
        yield fileSystem.deleteFile(downloadFilePath, false);
        (0, should_1.default)(yield fileSystem.exists(downloadFilePath)).false();
    });
}
function testDeleteDirectory(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        (0, should_1.default)(yield fileSystem.exists(testDirectory)).true();
        yield fileSystem.deleteFile(testDirectory, false);
        (0, should_1.default)(yield fileSystem.exists(testDirectory)).false();
    });
}
function testDeleteDirectoryRecursively(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const downloadFilePath = resolve(testDirectory, 'download.png');
        yield fileSystem.downloadFile(downloadFilePath, IMAGE_URI);
        (0, should_1.default)(yield fileSystem.exists(testDirectory)).true();
        yield fileSystem.deleteFile(testDirectory, true);
        (0, should_1.default)(yield fileSystem.exists(downloadFilePath)).false();
        (0, should_1.default)(yield fileSystem.exists(testDirectory)).false();
    });
}
function testDeleteDirectoryNotRecursivelyFail(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const downloadFilePath = resolve(testDirectory, 'download.png');
        yield fileSystem.downloadFile(downloadFilePath, IMAGE_URI);
        (0, should_1.default)(yield fileSystem.exists(testDirectory)).true();
        yield (0, should_1.default)(fileSystem.deleteFile(testDirectory, false)).rejected();
        (0, should_1.default)(yield fileSystem.exists(downloadFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(testDirectory)).true();
    });
}
function testDeleteFileNotExistingFail(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const downloadFilePath = resolve(testDirectory, 'download.png');
        (0, should_1.default)(yield fileSystem.exists(downloadFilePath)).false();
        yield (0, should_1.default)(fileSystem.deleteFile(downloadFilePath, false)).rejected();
        yield (0, should_1.default)(fileSystem.deleteFile(downloadFilePath, true)).rejected();
    });
}
function testCreateDirectory(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const newDirectory = resolve(testDirectory, 'new-directory');
        yield fileSystem.createDirectory(newDirectory);
        (0, should_1.default)(yield fileSystem.exists(newDirectory)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(newDirectory)).true();
    });
}
function testCreateDirectoryFailIfAlreadyExists(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        yield (0, should_1.default)(fileSystem.createDirectory(testDirectory)).rejected();
    });
}
function testCreateDirectoryFailIfCreatingNested(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const newDirectory = resolve(testDirectory, 'absent/nested');
        yield (0, should_1.default)(fileSystem.createDirectory(newDirectory)).rejected();
    });
}
function testDownloadFile(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const downloadFilePath = resolve(testDirectory, 'download.png');
        yield fileSystem.downloadFile(downloadFilePath, IMAGE_URI);
        (0, should_1.default)(yield fileSystem.exists(downloadFilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(downloadFilePath)).false();
    });
}
function testDownloadTextFile(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const downloadFilePath = resolve(testDirectory, 'download.png');
        yield fileSystem.downloadFile(downloadFilePath, TEXT_URI);
        (0, should_1.default)(yield fileSystem.exists(downloadFilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(downloadFilePath)).false();
        const textFile = yield fileSystem.getFile(downloadFilePath);
        const textResponse = yield fetch(textFile.localUri);
        const textContent = yield textResponse.text();
        (0, should_1.default)(textContent).equal('content-1\n');
    });
}
function testDownloadOverridesOriginalFile(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const downloadFilePath = resolve(testDirectory, 'download.png');
        yield fileSystem.downloadFile(downloadFilePath, TEXT_URI);
        const firstFile = yield fileSystem.getFile(downloadFilePath);
        const firstResponse = yield fetch(firstFile.localUri);
        const firstContent = yield firstResponse.text();
        (0, should_1.default)(firstContent).equal('content-1\n');
        yield fileSystem.downloadFile(downloadFilePath, TEXT2_URI);
        const secondFile = yield fileSystem.getFile(downloadFilePath);
        const secondResponse = yield fetch(secondFile.localUri);
        const secondContent = yield secondResponse.text();
        (0, should_1.default)(secondContent).equal('content-2\n');
    });
}
function testDownloadToNotExistingContainingDirectoryFail(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const downloadFilePath = resolve(testDirectory, 'sub-directory/download.png');
        yield (0, should_1.default)(fileSystem.downloadFile(downloadFilePath, TEXT_URI)).rejected();
    });
}
function testDownloadToExistingDirectoryPathFail(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const folder = resolve(testDirectory, 'folder');
        yield fileSystem.createDirectory(folder);
        yield (0, should_1.default)(fileSystem.downloadFile(folder, TEXT_URI)).rejected();
    });
}
function testUploadFile(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const uploadFilePath = resolve(testDirectory, 'upload.txt');
        yield fileSystem.writeFile(uploadFilePath, 'test');
        const response = yield fileSystem.uploadFile(uploadFilePath, UPLOAD_URI, 'file');
        const remoteFileUri = response && JSON.parse(response).uri;
        (0, should_1.default)(remoteFileUri).String();
        const remoteResponse = yield fetch(remoteFileUri);
        const remoteContent = yield remoteResponse.text();
        (0, should_1.default)(remoteContent).equal('test');
    });
}
function testListFiles(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const file1 = resolve(testDirectory, 'file1');
        const file2 = resolve(testDirectory, 'file2');
        const folder = resolve(testDirectory, 'folder');
        const file3 = resolve(folder, 'file3');
        yield fileSystem.createDirectory(folder);
        yield Promise.all([
            fileSystem.downloadFile(file1, IMAGE_URI),
            fileSystem.downloadFile(file2, TEXT_URI),
            fileSystem.downloadFile(file3, ARCHIVE_URI),
        ]);
        const testFilePaths = yield fileSystem.listFiles(testDirectory);
        const filePathSortFunction = (a, b) => a.filePath.localeCompare(b.filePath);
        (0, should_1.default)(testFilePaths.sort(filePathSortFunction)).eql([file1, file2, folder]);
        const testFolderFilePaths = yield fileSystem.listFiles(folder);
        (0, should_1.default)(testFolderFilePaths).eql([file3]);
    });
}
function testListFilesOfNotExistingDirectoryFail(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const absentDirectory = resolve(testDirectory, 'absent');
        yield (0, should_1.default)(fileSystem.listFiles(absentDirectory)).rejected();
    });
}
function testListFilesOfFileFail(fileSystem, testDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const downloadFilePath = resolve(testDirectory, 'download.png');
        yield fileSystem.downloadFile(downloadFilePath, TEXT_URI);
        yield (0, should_1.default)(fileSystem.listFiles(downloadFilePath)).rejected();
    });
}
function testCopyFile(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const fromFilePath = resolve(fromTestDirectory, 'file1');
        const toFilePath = resolve(toTestDirectory, 'file2');
        yield fileSystem.downloadFile(fromFilePath, IMAGE_URI);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).false();
        yield fileSystem.copyFile(fromFilePath, toFilePath);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
    });
}
function testCopyDirectory(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const fromSubDirectoryPath = resolve(fromTestDirectory, 'dir');
        const fromFilePath = resolve(fromSubDirectoryPath, 'file1');
        const toFilePath = resolve(toTestDirectory, 'dir2');
        const toSubFilePath = resolve(toFilePath, 'file1');
        yield fileSystem.createDirectory(fromSubDirectoryPath);
        yield fileSystem.downloadFile(fromFilePath, IMAGE_URI);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).false();
        (0, should_1.default)(yield fileSystem.exists(toSubFilePath)).false();
        yield fileSystem.copyFile(fromSubDirectoryPath, toFilePath);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(toFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toSubFilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(toSubFilePath)).false();
    });
}
function testCopyFileOverwriteExistingPath(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const fromFilePath = resolve(fromTestDirectory, 'file1');
        const toFilePath = resolve(toTestDirectory, 'file2');
        yield fileSystem.writeFile(fromFilePath, 'source');
        yield fileSystem.writeFile(toFilePath, 'destination');
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
        yield fileSystem.copyFile(fromFilePath, toFilePath, { overwrite: true });
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
        (0, should_1.default)(yield fileSystem.readFile(toFilePath)).equal('source');
    });
}
function testCopyDirectoryOverwriteExistingPath(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const fromSubDirectoryPath = resolve(fromTestDirectory, 'dir');
        const fromFilePath = resolve(fromSubDirectoryPath, 'file1');
        const toFilePath = resolve(toTestDirectory, 'dir2');
        const toSubFilePath = resolve(toFilePath, 'file1');
        yield fileSystem.createDirectory(fromSubDirectoryPath);
        yield fileSystem.writeFile(fromFilePath, 'source');
        yield fileSystem.createDirectory(toFilePath);
        yield fileSystem.writeFile(toSubFilePath, 'destination');
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toSubFilePath)).true();
        yield fileSystem.copyFile(fromSubDirectoryPath, toFilePath, { overwrite: true });
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(toFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toSubFilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(toSubFilePath)).false();
        (0, should_1.default)(yield fileSystem.readFile(toSubFilePath)).equal('source');
    });
}
function testCopyFileToAlreadyExistingPathFail(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const fromFilePath = resolve(fromTestDirectory, 'file1');
        const toFilePath = resolve(toTestDirectory, 'file2');
        yield fileSystem.downloadFile(fromFilePath, IMAGE_URI);
        yield fileSystem.downloadFile(toFilePath, TEXT_URI);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
        yield (0, should_1.default)(fileSystem.copyFile(fromFilePath, toFilePath)).rejected();
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
    });
}
function testCopyFileToNotExistingContainingPathFail(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const fromFilePath = resolve(fromTestDirectory, 'file1');
        const toFilePath = resolve(toTestDirectory, 'absent/file2');
        yield fileSystem.downloadFile(fromFilePath, IMAGE_URI);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).false();
        yield (0, should_1.default)(fileSystem.copyFile(fromFilePath, toFilePath)).rejected();
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).false();
    });
}
function testCopyFileFromNotExistingPathFail(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const fromFilePath = resolve(fromTestDirectory, 'file1');
        const toFilePath = resolve(toTestDirectory, 'file2');
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).false();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).false();
        yield (0, should_1.default)(fileSystem.copyFile(fromFilePath, toFilePath)).rejected();
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).false();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).false();
    });
}
function testMoveFile(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const fromFilePath = resolve(fromTestDirectory, 'file1');
        const toFilePath = resolve(toTestDirectory, 'file2');
        yield fileSystem.downloadFile(fromFilePath, IMAGE_URI);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).false();
        yield fileSystem.moveFile(fromFilePath, toFilePath);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).false();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
    });
}
function testMoveDirectory(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const fromSubDirectoryPath = resolve(fromTestDirectory, 'dir');
        const fromFilePath = resolve(fromSubDirectoryPath, 'file1');
        const toFilePath = resolve(toTestDirectory, 'dir2');
        const toSubFilePath = resolve(toFilePath, 'file1');
        yield fileSystem.createDirectory(fromSubDirectoryPath);
        yield fileSystem.downloadFile(fromFilePath, IMAGE_URI);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).false();
        (0, should_1.default)(yield fileSystem.exists(toSubFilePath)).false();
        yield fileSystem.moveFile(fromSubDirectoryPath, toFilePath);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).false();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(toFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toSubFilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(toSubFilePath)).false();
    });
}
function testMoveFileToAlreadyExistingPathFail(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const fromFilePath = resolve(fromTestDirectory, 'file1');
        const toFilePath = resolve(toTestDirectory, 'file2');
        yield fileSystem.downloadFile(fromFilePath, IMAGE_URI);
        yield fileSystem.downloadFile(toFilePath, TEXT_URI);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
        yield (0, should_1.default)(fileSystem.moveFile(fromFilePath, toFilePath)).rejected();
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
    });
}
function testMoveFileOverwrite(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const fromFilePath = resolve(fromTestDirectory, 'file1');
        const toFilePath = resolve(toTestDirectory, 'file2');
        yield fileSystem.writeFile(fromFilePath, 'source');
        yield fileSystem.writeFile(toFilePath, 'destination');
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
        yield fileSystem.moveFile(fromFilePath, toFilePath, { overwrite: true });
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).false();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
        (0, should_1.default)(yield fileSystem.readFile(toFilePath)).equal('source');
    });
}
function testMoveDirectoryOverwrite(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const fromSubDirectoryPath = resolve(fromTestDirectory, 'dir');
        const fromFilePath = resolve(fromSubDirectoryPath, 'file1');
        const toFilePath = resolve(toTestDirectory, 'dir2');
        const toSubFilePath = resolve(toFilePath, 'file1');
        yield fileSystem.createDirectory(fromSubDirectoryPath);
        yield fileSystem.createDirectory(toFilePath);
        yield fileSystem.writeFile(fromFilePath, 'source');
        yield fileSystem.writeFile(toSubFilePath, 'destination');
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toSubFilePath)).true();
        yield fileSystem.moveFile(fromSubDirectoryPath, toFilePath, { overwrite: true });
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).false();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(toFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toSubFilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(toSubFilePath)).false();
        (0, should_1.default)(yield fileSystem.readFile(toSubFilePath)).equal('source');
    });
}
function testMoveFileToNotExistingContainingPathFail(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const fromFilePath = resolve(fromTestDirectory, 'file1');
        const toFilePath = resolve(toTestDirectory, 'dir1/file2');
        yield fileSystem.downloadFile(fromFilePath, IMAGE_URI);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).false();
        yield (0, should_1.default)(fileSystem.moveFile(fromFilePath, toFilePath)).rejected();
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).false();
    });
}
function testMoveFileFromNotExistingPathFail(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const fromFilePath = resolve(fromTestDirectory, 'file1');
        const toFilePath = resolve(toTestDirectory, 'file2');
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).false();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).false();
        yield (0, should_1.default)(fileSystem.moveFile(fromFilePath, toFilePath)).rejected();
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).false();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).false();
    });
}
function testLinkFile(fileSystem, fromTestDirectory, toTestDirectory, supportsLink) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!(yield supportsLink())) {
            t.skip(`Device doesn't provide ${FrontCapability_1.default[FrontCapability_1.default.FILE_SYSTEM_LINK]} capability`);
            return;
        }
        const fromFilePath = resolve(fromTestDirectory, 'file1');
        const toFilePath = resolve(toTestDirectory, 'file2');
        yield fileSystem.downloadFile(fromFilePath, IMAGE_URI);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).false();
        yield fileSystem.link(fromFilePath, toFilePath);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
    });
}
function testLinkFileToExistingPathFail(fileSystem, fromTestDirectory, toTestDirectory, supportsLink) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!(yield supportsLink())) {
            t.skip(`Device doesn't provide ${FrontCapability_1.default[FrontCapability_1.default.FILE_SYSTEM_LINK]} capability`);
            return;
        }
        const fromFilePath = resolve(fromTestDirectory, 'file1');
        const toFilePath = resolve(toTestDirectory, 'file2');
        yield fileSystem.downloadFile(fromFilePath, IMAGE_URI);
        yield fileSystem.downloadFile(toFilePath, TEXT_URI);
        (0, should_1.default)(yield fileSystem.exists(fromFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(toFilePath)).true();
        let rejected = false;
        try {
            yield fileSystem.link(fromFilePath, toFilePath);
        }
        catch (error) {
            if (error instanceof basicErrors_1.NotSupportedMethodError) {
                throw error;
            }
            rejected = true;
        }
        if (!rejected) {
            throw new Error('link was expected to be rejected but it resolved');
        }
    });
}
function testGetFileChecksum(fileSystem, testDirectory, supportsFileChecksum) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!(yield supportsFileChecksum())) {
            t.skip(`Device doesn't provide ${FrontCapability_1.default[FrontCapability_1.default.FILE_SYSTEM_FILE_CHECKSUM]} capability`);
            return;
        }
        const checksumFilePath = resolve(testDirectory, 'checksum-file');
        yield fileSystem.downloadFile(checksumFilePath, IMAGE_URI);
        (0, should_1.default)(yield fileSystem.getFileChecksum(checksumFilePath, HashAlgorithm_1.default.MD5)).equal('f87b2be019aa1cf704680b8984aaa5b9');
    });
}
function testGetFileChecksumOnPictures(fileSystem, testDirectory, supportsFileChecksum) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!(yield supportsFileChecksum())) {
            t.skip(`Device doesn't provide ${FrontCapability_1.default[FrontCapability_1.default.FILE_SYSTEM_FILE_CHECKSUM]} capability`);
            return;
        }
        const checksumFilePathBlack = resolve(testDirectory, 'checksum-file-' + 'CAR_BLACK_IMAGE_URI');
        yield fileSystem.downloadFile(checksumFilePathBlack, CAR_BLACK_IMAGE_URI, { 'checksum-crc32': 'enabled' });
        (0, should_1.default)(yield fileSystem.getFileChecksum(checksumFilePathBlack, HashAlgorithm_1.default.CRC32)).equal('056fa2ca');
        const checksumFilePathBlue = resolve(testDirectory, 'checksum-file-' + 'CAR_BLUE_IMAGE_URI');
        yield fileSystem.downloadFile(checksumFilePathBlue, CAR_BLUE_IMAGE_URI, { 'checksum-crc32': 'enabled' });
        (0, should_1.default)(yield fileSystem.getFileChecksum(checksumFilePathBlue, HashAlgorithm_1.default.CRC32)).equal('9a648a53');
        const checksumFilePathOrange = resolve(testDirectory, 'checksum-file-' + 'CAR_ORANGE_IMAGE_URI');
        yield fileSystem.downloadFile(checksumFilePathOrange, CAR_ORANGE_IMAGE_URI, { 'checksum-crc32': 'enabled' });
        (0, should_1.default)(yield fileSystem.getFileChecksum(checksumFilePathOrange, HashAlgorithm_1.default.CRC32)).equal('7d7911ee');
        const checksumFilePathBlueBack = resolve(testDirectory, 'checksum-file-' + 'BLUE_BACK_IMAGE_URI');
        yield fileSystem.downloadFile(checksumFilePathBlueBack, BLUE_BACK_IMAGE_URI, { 'checksum-crc32': 'enabled' });
        (0, should_1.default)(yield fileSystem.getFileChecksum(checksumFilePathBlueBack, HashAlgorithm_1.default.CRC32)).equal('4d60de84');
    });
}
function testGetFileChecksumOfNotExistingFileFail(fileSystem, testDirectory, supportsFileChecksum) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!(yield supportsFileChecksum())) {
            t.skip(`Device doesn't provide ${FrontCapability_1.default[FrontCapability_1.default.FILE_SYSTEM_FILE_CHECKSUM]} capability`);
            return;
        }
        const checksumFilePath = resolve(testDirectory, 'unknown-checksum-file');
        yield (0, should_1.default)(fileSystem.getFileChecksum(checksumFilePath, HashAlgorithm_1.default.MD5)).rejected();
    });
}
function testGetFileChecksumOfDirectoryFail(fileSystem, testDirectory, supportsFileChecksum) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!(yield supportsFileChecksum())) {
            t.skip(`Device doesn't provide ${FrontCapability_1.default[FrontCapability_1.default.FILE_SYSTEM_FILE_CHECKSUM]} capability`);
            return;
        }
        yield (0, should_1.default)(fileSystem.getFileChecksum(testDirectory, HashAlgorithm_1.default.MD5)).rejected();
    });
}
function testExtractFileZip(fileSystem, fromTestDirectory, toTestDirectory, createOutputDirectory = true) {
    return __awaiter(this, void 0, void 0, function* () {
        const archiveFilePath = resolve(fromTestDirectory, 'archive.zip');
        const extractDirectoryFilePath = resolve(toTestDirectory, 'extracted');
        if (createOutputDirectory) {
            yield fileSystem.createDirectory(extractDirectoryFilePath);
        }
        yield fileSystem.downloadFile(archiveFilePath, ARCHIVE_URI);
        yield fileSystem.extractFile(archiveFilePath, extractDirectoryFilePath, 'zip');
        const file1FilePath = resolve(extractDirectoryFilePath, 'my-file1');
        const file2FilePath = resolve(extractDirectoryFilePath, 'my-file2');
        const folderFilePath = resolve(extractDirectoryFilePath, 'my-folder');
        const file3FilePath = resolve(folderFilePath, 'my-file3');
        const subFolderFilePath = resolve(folderFilePath, 'sub-folder');
        const file4FilePath = resolve(subFolderFilePath, 'my-file4');
        (0, should_1.default)(yield fileSystem.exists(file1FilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(file1FilePath)).false();
        (0, should_1.default)(yield fileSystem.exists(file2FilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(file2FilePath)).false();
        (0, should_1.default)(yield fileSystem.exists(folderFilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(folderFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(file3FilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(file3FilePath)).false();
        (0, should_1.default)(yield fileSystem.exists(subFolderFilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(subFolderFilePath)).true();
        (0, should_1.default)(yield fileSystem.exists(file4FilePath)).true();
        (0, should_1.default)(yield fileSystem.isDirectory(file4FilePath)).false();
        const file1 = yield fileSystem.getFile(file1FilePath);
        const text1Response = yield fetch(file1.localUri);
        const text1Content = yield text1Response.text();
        (0, should_1.default)(text1Content).equal('content-1\n');
        const file2 = yield fileSystem.getFile(file2FilePath);
        const text2Response = yield fetch(file2.localUri);
        const text2Content = yield text2Response.text();
        (0, should_1.default)(text2Content).equal('content-2\n');
        const file3 = yield fileSystem.getFile(file3FilePath);
        const text3Response = yield fetch(file3.localUri);
        const text3Content = yield text3Response.text();
        (0, should_1.default)(text3Content).equal('content-3\n');
        const file4 = yield fileSystem.getFile(file4FilePath);
        const text4Response = yield fetch(file4.localUri);
        const text4Content = yield text4Response.text();
        (0, should_1.default)(text4Content).equal('content-4\n');
    });
}
function testExtractFileZipOverridesExisting(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const extractDirectoryFilePath = resolve(toTestDirectory, 'extracted');
        const file1FilePath = resolve(extractDirectoryFilePath, 'my-file1');
        const file2FilePath = resolve(extractDirectoryFilePath, 'my-file2');
        const folderFilePath = resolve(extractDirectoryFilePath, 'my-folder');
        const file3FilePath = resolve(folderFilePath, 'my-file3');
        const subFolderFilePath = resolve(folderFilePath, 'sub-folder');
        const file4FilePath = resolve(subFolderFilePath, 'my-file4');
        yield fileSystem.createDirectory(extractDirectoryFilePath);
        yield fileSystem.writeFile(file1FilePath, 'bad');
        yield fileSystem.writeFile(file2FilePath, 'bad');
        yield fileSystem.createDirectory(folderFilePath);
        yield fileSystem.writeFile(file3FilePath, 'bad');
        yield fileSystem.createDirectory(subFolderFilePath);
        yield fileSystem.writeFile(file4FilePath, 'bad');
        yield testExtractFileZip(fileSystem, fromTestDirectory, toTestDirectory, false);
    });
}
function testExtractFileZipIfArchiveNotExistsFail(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const archiveFilePath = resolve(fromTestDirectory, 'archive.zip');
        const extractDirectoryFilePath = resolve(toTestDirectory, 'extracted');
        yield fileSystem.createDirectory(extractDirectoryFilePath);
        yield (0, should_1.default)(fileSystem.extractFile(archiveFilePath, extractDirectoryFilePath, 'zip')).rejected();
    });
}
function testExtractFileZipIfTargetNotExists(fileSystem, fromTestDirectory, toTestDirectory) {
    return __awaiter(this, void 0, void 0, function* () {
        const archiveFilePath = resolve(fromTestDirectory, 'archive.zip');
        const extractDirectoryFilePath = resolve(toTestDirectory, 'extracted');
        yield fileSystem.downloadFile(archiveFilePath, ARCHIVE_URI);
        yield fileSystem.extractFile(archiveFilePath, extractDirectoryFilePath, 'zip');
    });
}
function testGetArchiveSize(fileSystem, testDirectory, supportsArchiveInfo) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!(yield supportsArchiveInfo())) {
            t.skip(`Device doesn't provide ${FrontCapability_1.default[FrontCapability_1.default.FILE_SYSTEM_ARCHIVE_EXTRACT_INFO]} capability`);
            return;
        }
        const archiveFilePath = resolve(testDirectory, 'archive.zip');
        yield fileSystem.downloadFile(archiveFilePath, ARCHIVE_URI);
        const { uncompressedSize } = yield fileSystem.getArchiveInfo(archiveFilePath);
        (0, should_1.default)(uncompressedSize).be.eql(40);
    });
}
function testGetArchiveSizeIfArchiveNotExistsFail(fileSystem, testDirectory, supportsArchiveInfo) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!(yield supportsArchiveInfo())) {
            t.skip(`Device doesn't provide ${FrontCapability_1.default[FrontCapability_1.default.FILE_SYSTEM_ARCHIVE_EXTRACT_INFO]} capability`);
            return;
        }
        const archiveFilePath = resolve(testDirectory, 'unknown_archive.zip');
        yield (0, should_1.default)(fileSystem.getArchiveInfo(archiveFilePath)).rejected();
    });
}
function getInternalStorageUnit(fileSystem) {
    return __awaiter(this, void 0, void 0, function* () {
        const storageUnits = yield fileSystem.listStorageUnits();
        const storageUnit = storageUnits.find((su) => !su.removable);
        return storageUnit;
    });
}
function getFirstExternalStorageUnit(fileSystem) {
    return __awaiter(this, void 0, void 0, function* () {
        const storageUnits = yield fileSystem.listStorageUnits();
        const storageUnit = storageUnits.find((su) => su.removable);
        return storageUnit;
    });
}
function createDirectories(fileSystem, ...filePaths) {
    return __awaiter(this, void 0, void 0, function* () {
        yield Promise.all(filePaths.map((filePath) => __awaiter(this, void 0, void 0, function* () {
            yield fileSystem.createDirectory(filePath);
        })));
    });
}
function deleteRecursivelyIfExists(fileSystem, ...filePaths) {
    return __awaiter(this, void 0, void 0, function* () {
        yield Promise.all(filePaths.map((filePath) => __awaiter(this, void 0, void 0, function* () {
            if (yield fileSystem.exists(filePath)) {
                yield fileSystem.deleteFile(filePath, true);
            }
        })));
    });
}
function* manageTestDirectories(fileSystem, ...filePaths) {
    yield t.beforeEach('clear test directory', () => __awaiter(this, void 0, void 0, function* () {
        yield deleteRecursivelyIfExists(fileSystem, ...filePaths);
        yield createDirectories(fileSystem, ...filePaths);
    }));
    yield t.afterEach('clear test directory', () => __awaiter(this, void 0, void 0, function* () {
        yield deleteRecursivelyIfExists(fileSystem, ...filePaths);
    }));
}
function resolve(base, filePath) {
    if (filePath.startsWith('/')) {
        return Object.assign(Object.assign({}, base), { filePath });
    }
    else if (filePath.startsWith('.')) {
        throw new Error('Not implemented');
    }
    else {
        return Object.assign(Object.assign({}, base), { filePath: base.filePath + '/' + filePath });
    }
}
//# sourceMappingURL=FileSystemTest.js.map