"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.socket = void 0;
const socketActions_1 = require("@signageos/actions/dist/Socket/socketActions");
const initialState = {
    connected: false,
    wasDisconnected: false,
};
function socket(state = initialState, action) {
    switch (action.type) {
        case socketActions_1.SocketDisconnected:
            return Object.assign(Object.assign({}, state), { connected: false, wasDisconnected: true });
        case socketActions_1.SocketConnected:
            return Object.assign(Object.assign({}, state), { connected: true, wasDisconnected: false });
        default:
            return state;
    }
}
exports.socket = socket;
//# sourceMappingURL=socketReducers.js.map