"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCompatibleSecurity = exports.createSecurity = exports.DEFAULT_OPEN_PIN_CODE = void 0;
const propertyStorage_1 = __importDefault(require("../../Property/propertyStorage"));
const DefaultSecurity_1 = __importDefault(require("./DefaultSecurity"));
const PinPropertyStorage_1 = __importDefault(require("./PinPropertyStorage"));
exports.DEFAULT_OPEN_PIN_CODE = '0000';
function createSecurity(storage, onSetPin) {
    return new DefaultSecurity_1.default(storage, onSetPin);
}
exports.createSecurity = createSecurity;
function createCompatibleSecurity(...args) {
    const getFrontDriver = args[0];
    const getCacheDriver = args.length === 1 ? args[0] : args[1];
    const properties = (0, propertyStorage_1.default)(getCacheDriver);
    const storage = new PinPropertyStorage_1.default(properties);
    return createSecurity(storage, (pin) => getFrontDriver().controlSetPin(pin));
}
exports.createCompatibleSecurity = createCompatibleSecurity;
//# sourceMappingURL=security.js.map