import IPinStorage from './IPinStorage';
import ISecurity from './ISecurity';
export default class DefaultSecurity implements ISecurity {
    private readonly storage;
    private readonly setPinDelegate;
    private readonly events;
    constructor(storage: IPinStorage, setPinDelegate: (pin: string) => Promise<void>);
    isSecure(): Promise<boolean>;
    verifyPin(pin: string): Promise<boolean>;
    getPin(): Promise<string>;
    setPin(newPin: string): Promise<void>;
    onPinSet(listener: () => void): () => void;
}
