"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkingStatusChange = exports.networkConnection = void 0;
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const networkActions_1 = require("@signageos/actions/dist/Network/networkActions");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const lodash_1 = __importDefault(require("lodash"));
const effects_1 = require("redux-saga/effects");
const networkActions_2 = require("./networkActions");
function* networkConnection(getState, getNativeDriver, getManagementDriver) {
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, checkingConnection, getState, getNativeDriver);
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, checkingStatusChange, getManagementDriver);
}
exports.networkConnection = networkConnection;
function* checkingConnection(getState, getNativeDriver) {
    try {
        while (true) {
            const isNowConnected = yield getNativeDriver().isConnected();
            if (getState().network.connected !== isNowConnected) {
                yield (0, effects_1.put)({
                    type: isNowConnected ? networkActions_1.Connected : networkActions_1.Disconnected,
                });
            }
            yield (0, effects_1.call)(wait_1.default, 60 * 1e3);
        }
    }
    catch (error) {
        console.error('checkingConnection failed', error);
    }
}
function* checkingStatusChange(getManagementDriver) {
    let lastStatus = [];
    try {
        while (true) {
            const status = yield getManagementDriver().network.listInterfaces();
            if (!lodash_1.default.isEqual(lastStatus, status)) {
                yield (0, effects_1.put)({ type: networkActions_2.NetworkStatusChanged, data: status });
                lastStatus = status;
            }
            yield (0, effects_1.call)(wait_1.default, 60e3);
        }
    }
    catch (error) {
        console.error('checkingStatusChange failed', error);
    }
}
exports.checkingStatusChange = checkingStatusChange;
//# sourceMappingURL=networkSagas.js.map