"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNumericCode = void 0;
const KeyCode_1 = require("../../NativeDevice/Input/KeyCode");
const CharacterKeyMap = {
    [KeyCode_1.KeyCode.NUM_0]: 0,
    [KeyCode_1.KeyCode.NUM_1]: 1,
    [KeyCode_1.KeyCode.NUM_2]: 2,
    [KeyCode_1.KeyCode.NUM_3]: 3,
    [KeyCode_1.KeyCode.NUM_4]: 4,
    [KeyCode_1.KeyCode.NUM_5]: 5,
    [KeyCode_1.KeyCode.NUM_6]: 6,
    [KeyCode_1.KeyCode.NUM_7]: 7,
    [KeyCode_1.KeyCode.NUM_8]: 8,
    [KeyCode_1.KeyCode.NUM_9]: 9,
};
function getNumericCode(sequence) {
    return sequence.reduce((numericCode, keyCode) => {
        if (Object.keys(CharacterKeyMap).indexOf(KeyCode_1.KeyCode[keyCode].toString()) !== -1) {
            return numericCode + CharacterKeyMap[KeyCode_1.KeyCode[keyCode]];
        }
        if (keyCode === KeyCode_1.KeyCode[KeyCode_1.KeyCode.BACKSPACE]) {
            return numericCode.slice(0, numericCode.length - 1);
        }
        return numericCode;
    }, '');
}
exports.getNumericCode = getNumericCode;
//# sourceMappingURL=numericSequence.js.map