"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.motionSequenceSaga = void 0;
const effects_1 = require("redux-saga/effects");
const motionActions_1 = require("@signageos/actions/dist/Input/motionActions");
function* motionSequenceSaga(window) {
    let cleanSequenceTimeout;
    let pressedSequence = [];
    yield (0, effects_1.takeEvery)(motionActions_1.HandleMotion, function* (handleMotion) {
        try {
            window.clearTimeout(cleanSequenceTimeout);
            yield (0, effects_1.fork)(function* () {
                yield new Promise((resolve) => {
                    cleanSequenceTimeout = window.setTimeout(() => resolve(), 4 * 1e3);
                });
                pressedSequence = [];
                yield (0, effects_1.put)({
                    type: motionActions_1.HandleMotionSequence,
                    sequence: [...pressedSequence],
                });
            });
            pressedSequence.push(handleMotion.gestureAction);
            yield (0, effects_1.put)({
                type: motionActions_1.HandleMotionSequence,
                sequence: [...pressedSequence],
            });
        }
        catch (error) {
            console.error('motionSequenceSaga', error);
        }
    });
}
exports.motionSequenceSaga = motionSequenceSaga;
//# sourceMappingURL=motionSagas.js.map