"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.keyboard = void 0;
const keyboardActions_1 = require("@signageos/actions/dist/Input/keyboardActions");
const keyActions_1 = require("@signageos/actions/dist/Input/keyActions");
const deviceRemoteControlActions_1 = require("../../Device/RemoteControl/deviceRemoteControlActions");
const numericSequence_1 = require("./numericSequence");
const initialState = {
    showNumericKeyboard: false,
    numericCode: null,
};
function keyboard(state = initialState, action) {
    switch (action.type) {
        case keyboardActions_1.ShowNumericKeyboard:
            return Object.assign(Object.assign({}, state), { showNumericKeyboard: true });
        case keyboardActions_1.HideNumericKeyboard:
        case deviceRemoteControlActions_1.DeviceRemoteControlSet:
            return Object.assign(Object.assign({}, state), { showNumericKeyboard: false });
        case keyActions_1.HandleKeySequence:
            return Object.assign(Object.assign({}, state), { numericCode: (0, numericSequence_1.getNumericCode)(action.sequence) });
        default:
            return state;
    }
}
exports.keyboard = keyboard;
//# sourceMappingURL=keyboardReducers.js.map