import { UpdateDeviceTelemetryRecord } from '@signageos/actions/dist/Device/Telemetry/deviceTelemetryActions';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import { PutEffect } from 'redux-saga/effects';
import FrontCapability from '../../NativeDevice/Front/FrontCapability';
import IFrontDriver from '../../NativeDevice/Front/IFrontDriver';
import IBasicDriver from '../../NativeDevice/IBasicDriver';
import { IFrontManagementDriver } from '../../NativeDevice/Management/IManagementDriver';
import { IPropertyStorage } from '../../Property/propertyStorage';
export declare function updateTitle(window: Window): Generator<import("redux-saga/effects").ForkEffect<any>, void, unknown>;
export declare function notifyDeviceSaga(getNativeDriver: () => IFrontManagementDriver): Generator<import("redux-saga/effects").ForkEffect<never>, void, unknown>;
export declare function notifyDeviceApplicationVersion(getNativeDriver: () => IBasicDriver, applicationVersion: string): Generator<import("redux-saga/effects").ForkEffect<never>, void, unknown>;
export declare function updateDeviceLocation(propertyStorage: IPropertyStorage): Generator<import("redux-saga/effects").ForkEffect<any>, void, unknown>;
export declare function updateOrganizationTags(propertyStorage: IPropertyStorage): Generator<import("redux-saga/effects").ForkEffect<any>, void, unknown>;
/**
 * Update device location and organization tags in local storage
 * which can be later retrieved by the JS API.
 */
export declare function getDeviceLocationAndTags(): Generator<import("redux-saga/effects").ForkEffect<never>, void, unknown>;
export declare function notifyFrontCapabilities(propertyStorage: IPropertyStorage, getNativeDriver: () => IFrontDriver): Generator<Promise<void> | Promise<boolean> | Promise<never[]> | Generator<Promise<void> | PutEffect<UpdateDeviceTelemetryRecord<DeviceTelemetryType.FRONT_CAPABILITIES, {
    capable: FrontCapability[];
}>>, UpdateDeviceTelemetryRecord<DeviceTelemetryType.FRONT_CAPABILITIES, {
    capable: FrontCapability[];
}>, import("../../Application/IActionWithEmitter").default>, void, boolean & {
    capable: FrontCapability[];
}>;
export declare const notifyFirmwareVersion: (getManagementDriver: () => IFrontManagementDriver) => () => Generator<Promise<string> | PutEffect<{
    type: string;
    version: string;
}>, void, string>;
