"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.cacheDeviceAuthHash = exports.startupDeviceAuthHash = void 0;
const socketActionCreator_1 = require("../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const deviceAuthenticationActions_1 = require("@signageos/actions/dist/Device/Authentication/deviceAuthenticationActions");
const Property_1 = __importDefault(require("../../Property/Property"));
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/front-display:Front:Device:deviceAuthenticationSagas');
function* startupDeviceAuthHash(propertyStorage) {
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, function* () {
        try {
            const lastDeviceAuthHash = yield propertyStorage.getValueOrDefault(Property_1.default.LAST_DEVICE_AUTH_HASH, null);
            if (lastDeviceAuthHash) {
                yield (0, effects_1.put)({
                    type: deviceAuthenticationActions_1.UpdateAuthentication,
                    authHash: lastDeviceAuthHash,
                });
            }
        }
        catch (error) {
            debug('No ' + Property_1.default.LAST_DEVICE_AUTH_HASH + ' found', error);
        }
    });
}
exports.startupDeviceAuthHash = startupDeviceAuthHash;
function* cacheDeviceAuthHash(propertyStorage) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(deviceAuthenticationActions_1.UpdateAuthentication, function* (action) {
        try {
            yield propertyStorage.setValue(Property_1.default.LAST_DEVICE_AUTH_HASH, action.authHash);
        }
        catch (error) {
            debug('cacheDeviceAuthHash failed', error);
        }
    });
}
exports.cacheDeviceAuthHash = cacheDeviceAuthHash;
//# sourceMappingURL=deviceAuthenticationSagas.js.map