"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchVerificationHash = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const deviceVerificationActions_1 = require("@signageos/actions/dist/Device/Verification/deviceVerificationActions");
function* dispatchVerificationHash(window) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(deviceVerificationActions_1.VerificationHashCreated, function* (verificationHashCreated) {
        const message = {
            type: 'verificationHash',
            verificationHash: verificationHashCreated.verificationHash,
        };
        if (window.opener) {
            window.opener.postMessage(message, '*');
        }
    });
}
exports.dispatchVerificationHash = dispatchVerificationHash;
//# sourceMappingURL=deviceVerificationSagas.js.map