"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFrontPowerActionTimer = void 0;
const CronPowerActionScheduler_1 = __importDefault(require("../../../NativeDevice/Power/CronPowerActionScheduler"));
const DefaultPowerActionTimer_1 = __importDefault(require("../../../NativeDevice/Power/DefaultPowerActionTimer"));
const powerActionTimerStorages_1 = require("../../../NativeDevice/Power/powerActionTimerStorages");
const Property_1 = __importDefault(require("../../../Property/Property"));
function createFrontPowerActionTimer(propertyStorage, executor) {
    const storage = (0, powerActionTimerStorages_1.createPowerActionTimerPropertyStorage)(propertyStorage, Property_1.default.POWER_ACTIONS_SCHEDULE_SETTINGS_FRONT);
    const scheduler = new CronPowerActionScheduler_1.default();
    return new DefaultPowerActionTimer_1.default(storage, scheduler, executor);
}
exports.createFrontPowerActionTimer = createFrontPowerActionTimer;
//# sourceMappingURL=powerActionTimers.js.map